/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.effects.MachineEffectModel;
import me.davidml16.acubelets.effects.SimpleParticle;
import me.davidml16.acubelets.enums.Rotation;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.utils.StringUtils;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;

public class CubeletBoxHandler {
    private HashMap<Location, CubeletMachine> boxes;
    private File file;
    private YamlConfiguration config;
    private Main main;

    public CubeletBoxHandler(Main main) {
        this.main = main;
        this.boxes = new HashMap();
    }

    public HashMap<Location, CubeletMachine> getBoxes() {
        return this.boxes;
    }

    public File getFile() {
        return this.file;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public CubeletMachine getBoxByLocation(Location location) {
        return this.boxes.get(location);
    }

    public void createBox(Location location, double d) {
        CubeletMachine cubeletMachine = new CubeletMachine(location, d, d, Rotation.SOUTH);
        this.boxes.put(location, cubeletMachine);
        this.main.getHologramImplementation().loadHolograms(cubeletMachine);
        this.config.set("locations", new ArrayList());
        int n = 1;
        for (CubeletMachine cubeletMachine2 : this.boxes.values()) {
            this.config.set("locations." + n + ".world", (Object)cubeletMachine2.getLocation().getWorld().getName());
            this.config.set("locations." + n + ".x", (Object)cubeletMachine2.getLocation().getBlockX());
            this.config.set("locations." + n + ".y", (Object)cubeletMachine2.getLocation().getBlockY());
            this.config.set("locations." + n + ".z", (Object)cubeletMachine2.getLocation().getBlockZ());
            this.config.set("locations." + n + ".rotation", (Object)cubeletMachine2.getRotation().toString());
            this.config.set("locations." + n + ".blockHeight", (Object)cubeletMachine2.getBlockHeight());
            this.config.set("locations." + n + ".permanentBlockHeight", (Object)cubeletMachine2.getPermanentBlockHeight());
            this.config.set("locations." + n + ".idleEffect.type", (Object)cubeletMachine2.getBlockEffectModel().name());
            this.config.set("locations." + n + ".idleEffect.particle", (Object)cubeletMachine2.getBlockEffectParticle().getParticle().name());
            ++n;
        }
        this.saveConfig();
    }

    public void removeBox(Location location) {
        if (this.boxes.containsKey(location)) {
            CubeletMachine cubeletMachine = this.getBoxByLocation(location);
            this.main.getHologramImplementation().removeHolograms(cubeletMachine);
            this.main.getHologramImplementation().clearHolograms(cubeletMachine);
            this.boxes.remove(location);
            this.config.set("locations", new ArrayList());
            int n = 1;
            for (CubeletMachine cubeletMachine2 : this.boxes.values()) {
                this.config.set("locations." + n + ".world", (Object)cubeletMachine2.getLocation().getWorld().getName());
                this.config.set("locations." + n + ".x", (Object)cubeletMachine2.getLocation().getBlockX());
                this.config.set("locations." + n + ".y", (Object)cubeletMachine2.getLocation().getBlockY());
                this.config.set("locations." + n + ".z", (Object)cubeletMachine2.getLocation().getBlockZ());
                this.config.set("locations." + n + ".rotation", (Object)cubeletMachine2.getRotation().toString());
                this.config.set("locations." + n + ".blockHeight", (Object)cubeletMachine2.getBlockHeight());
                this.config.set("locations." + n + ".permanentBlockHeight", (Object)cubeletMachine2.getPermanentBlockHeight());
                this.config.set("locations." + n + ".idleEffect.type", (Object)cubeletMachine2.getBlockEffectModel().name());
                this.config.set("locations." + n + ".idleEffect.particle", (Object)cubeletMachine2.getBlockEffectParticle().getParticle().name());
                ++n;
            }
            this.saveConfig();
        }
    }

    public void saveBoxes() {
        this.config.set("locations", new ArrayList());
        int n = 1;
        for (CubeletMachine cubeletMachine : this.boxes.values()) {
            this.config.set("locations." + n + ".world", (Object)cubeletMachine.getLocation().getWorld().getName());
            this.config.set("locations." + n + ".x", (Object)cubeletMachine.getLocation().getBlockX());
            this.config.set("locations." + n + ".y", (Object)cubeletMachine.getLocation().getBlockY());
            this.config.set("locations." + n + ".z", (Object)cubeletMachine.getLocation().getBlockZ());
            this.config.set("locations." + n + ".rotation", (Object)cubeletMachine.getRotation().toString());
            this.config.set("locations." + n + ".blockHeight", (Object)cubeletMachine.getBlockHeight());
            this.config.set("locations." + n + ".permanentBlockHeight", (Object)cubeletMachine.getPermanentBlockHeight());
            this.config.set("locations." + n + ".idleEffect.type", (Object)cubeletMachine.getBlockEffectModel().name());
            this.config.set("locations." + n + ".idleEffect.particle", (Object)cubeletMachine.getBlockEffectParticle().getParticle().name());
            ++n;
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadBoxes() {
        this.boxes.clear();
        File file = new File(this.main.getDataFolder(), "locations.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!file.exists()) {
            try {
                file.createNewFile();
                yamlConfiguration.set("locations", new ArrayList());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.file = file;
        this.config = yamlConfiguration;
        if (!yamlConfiguration.contains("locations")) {
            yamlConfiguration.set("locations", new ArrayList());
        }
        this.saveConfig();
        Main.log.sendMessage(Utils.translate(""));
        Main.log.sendMessage(Utils.translate("  &eLoading machines:"));
        if (yamlConfiguration.contains("locations")) {
            if (yamlConfiguration.getConfigurationSection("locations") != null) {
                for (int i = 1; i <= yamlConfiguration.getConfigurationSection("locations").getKeys(false).size(); ++i) {
                    Object object;
                    String string = yamlConfiguration.getString("locations." + i + ".world");
                    int n = yamlConfiguration.getInt("locations." + i + ".x");
                    int n2 = yamlConfiguration.getInt("locations." + i + ".y");
                    int n3 = yamlConfiguration.getInt("locations." + i + ".z");
                    if (Bukkit.getServer().getWorld(string) == null) continue;
                    Location location = new Location(Bukkit.getWorld((String)string), (double)n, (double)n2, (double)n3);
                    Rotation rotation = Rotation.SOUTH;
                    if (yamlConfiguration.contains("locations." + i + ".rotation")) {
                        rotation = Rotation.valueOf(yamlConfiguration.getString("locations." + i + ".rotation"));
                    }
                    double d = 0.875;
                    if (yamlConfiguration.contains("locations." + i + ".blockHeight")) {
                        d = yamlConfiguration.getDouble("locations." + i + ".blockHeight");
                    }
                    double d2 = d;
                    if (yamlConfiguration.contains("locations." + i + ".permanentBlockHeight")) {
                        d2 = yamlConfiguration.getDouble("locations." + i + ".permanentBlockHeight");
                    }
                    if (yamlConfiguration.contains("locations." + i + ".permanentBlockHeight")) {
                        d2 = yamlConfiguration.getDouble("locations." + i + ".permanentBlockHeight");
                    }
                    CubeletMachine cubeletMachine = new CubeletMachine(location, d, d2, rotation);
                    if (yamlConfiguration.contains("locations." + i + ".idleEffect.type")) {
                        object = StringUtils.getEnum(yamlConfiguration.getString("locations." + i + ".idleEffect.type"), MachineEffectModel.class).orElse(MachineEffectModel.NONE);
                        cubeletMachine.setBlockEffectModel((MachineEffectModel)((Object)object));
                    }
                    if (yamlConfiguration.contains("locations." + i + ".idleEffect.particle")) {
                        object = yamlConfiguration.getString("locations." + i + ".idleEffect.particle").equalsIgnoreCase("NONE") ? "FLAME" : yamlConfiguration.getString("locations." + i + ".idleEffect.particle");
                        Particle particle = Particle.valueOf((String)object);
                        SimpleParticle simpleParticle = SimpleParticle.of(particle).parseData("");
                        cubeletMachine.setBlockEffectParticle(simpleParticle);
                    }
                    this.boxes.put(location, cubeletMachine);
                }
            }
            yamlConfiguration.set("locations", new ArrayList());
            int n = 1;
            for (CubeletMachine cubeletMachine : this.boxes.values()) {
                if (cubeletMachine.getLocation().getWorld() == null) continue;
                yamlConfiguration.set("locations." + n + ".world", (Object)cubeletMachine.getLocation().getWorld().getName());
                yamlConfiguration.set("locations." + n + ".x", (Object)cubeletMachine.getLocation().getBlockX());
                yamlConfiguration.set("locations." + n + ".y", (Object)cubeletMachine.getLocation().getBlockY());
                yamlConfiguration.set("locations." + n + ".z", (Object)cubeletMachine.getLocation().getBlockZ());
                yamlConfiguration.set("locations." + n + ".rotation", (Object)cubeletMachine.getRotation().toString());
                yamlConfiguration.set("locations." + n + ".blockHeight", (Object)cubeletMachine.getBlockHeight());
                yamlConfiguration.set("locations." + n + ".permanentBlockHeight", (Object)cubeletMachine.getPermanentBlockHeight());
                yamlConfiguration.set("locations." + n + ".idleEffect.type", (Object)cubeletMachine.getBlockEffectModel().name());
                yamlConfiguration.set("locations." + n + ".idleEffect.particle", (Object)cubeletMachine.getBlockEffectParticle().getParticle().name());
                ++n;
            }
            this.saveConfig();
        }
        if (this.boxes.size() == 0) {
            Main.log.sendMessage(Utils.translate("    &cNo Cubelet Machines has been loaded!"));
        } else {
            Main.log.sendMessage(Utils.translate("    &b" + this.boxes.size() + " &aCubelet Machines loaded!"));
        }
    }
}

