/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.crafting;

import com.cryptomorin.xseries.XMaterial;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.crafting.CraftParentConversation;
import me.davidml16.acubelets.conversation.crafting.EditCraftParentConversation;
import me.davidml16.acubelets.menus.admin.crafting.EditCraftingIngredientsMenu;
import me.davidml16.acubelets.menus.admin.options.OptionsMainMenu;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditCraftingCraftsMenu
extends Menu {
    public EditCraftingCraftsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        List<CraftParent> list = this.getMain().getCubeletCraftingHandler().getCrafts();
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "Crafting editor | Crafts");
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.SUNFLOWER.parseItem()).setName(Utils.translate("&aCreate new craft")).toItemStack();
        int n3 = this.getMain().getCubeletCraftingHandler().getInventoryRows();
        ItemStack itemStack3 = new ItemBuilder(XMaterial.CHEST.parseItem()).setName(Utils.translate("&aModify gui rows")).setLore("", Utils.translate(" &7Actual rows: &6" + n3 + " " + (n3 == 6 ? "&c(Max reached)" : (n3 == 2 ? "&c(Min reached)" : ""))), "", Utils.translate("&eLeft-Click \u00bb &aAdd one row "), Utils.translate("&eMiddle-Click \u00bb &aReset to 4 rows "), Utils.translate("&eRight-Click \u00bb &aRemove one row")).toItemStack();
        ItemStack itemStack4 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack")).toItemStack();
        this.fillBorders(itemStack);
        inventory.setItem(38, itemStack2);
        inventory.setItem(40, itemStack4);
        inventory.setItem(42, itemStack3);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(36, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(36, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 14) {
            inventory.setItem(44, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(44, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, Math.min(n * 21 + 21, list.size()));
        }
        if (list.size() > 0) {
            for (CraftParent craftParent : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(this.getMain().getCubeletTypesHandler().getTypeBydId(craftParent.getCubeletType()).getIcon()).setName(Utils.translate("&a" + craftParent.getCubeletType())).setLore("", Utils.translate(" &7Cubelet: &6" + craftParent.getCubeletType() + " "), Utils.translate(" &7Slot: &6" + craftParent.getSlot() + " "), Utils.translate(" &7Ingredients: " + (craftParent.getIngrediens().size() > 0 ? "&6" : "&c") + craftParent.getIngrediens().size()), "", Utils.translate("&eLeft-Click \u00bb &aEdit ingredients "), Utils.translate("&eMiddle-Click \u00bb &aRemove craft "), Utils.translate("&eRight-Click \u00bb &aEdit craft ")).toItemStack()});
            }
        } else {
            int n4;
            ItemStack itemStack5 = new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny craft created")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7craft created. "), "").toItemStack();
            for (n4 = 10; n4 <= 16; ++n4) {
                inventory.setItem(n4, itemStack5);
            }
            for (n4 = 19; n4 <= 25; ++n4) {
                inventory.setItem(n4, itemStack5);
            }
            for (n4 = 28; n4 <= 34; ++n4) {
                inventory.setItem(n4, itemStack5);
            }
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        if (n == 36 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 44 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 38) {
            player.closeInventory();
            new CraftParentConversation(this.getMain()).getConversation(player).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 40) {
            new OptionsMainMenu(this.getMain(), player).open();
        } else if (n == 42) {
            if (inventoryClickEvent.getClick() == ClickType.LEFT) {
                if (this.getMain().getCubeletCraftingHandler().getInventoryRows() < 6) {
                    this.getMain().getCubeletCraftingHandler().setInventorySize(this.getMain().getCubeletCraftingHandler().getInventoryRows() + 1);
                    this.playSound(Menu.SoundType.CLICK);
                    this.reloadMenu();
                }
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                this.getMain().getCubeletCraftingHandler().setInventorySize(4);
                this.playSound(Menu.SoundType.CHICKEN_EGG_POP);
                this.reloadMenu();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT && this.getMain().getCubeletCraftingHandler().getInventoryRows() > 2) {
                this.getMain().getCubeletCraftingHandler().setInventorySize(this.getMain().getCubeletCraftingHandler().getInventoryRows() - 1);
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMenu();
            }
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (this.getMain().getCubeletCraftingHandler().getCrafts().size() == 0) {
                return;
            }
            String string = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            CraftParent craftParent = this.getMain().getCubeletCraftingHandler().getCraftById(string);
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                EditCraftingIngredientsMenu editCraftingIngredientsMenu = new EditCraftingIngredientsMenu(this.getMain(), player);
                editCraftingIngredientsMenu.setAttribute(Menu.AttrType.CRAFT_PARENT_ATTR, craftParent);
                editCraftingIngredientsMenu.open();
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                this.getMain().getCubeletCraftingHandler().getCrafts().remove(craftParent);
                this.getMain().getCubeletCraftingHandler().saveCrafting();
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMenu();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                player.closeInventory();
                new EditCraftParentConversation(this.getMain()).getConversation(player, craftParent).begin();
                this.playSound(Menu.SoundType.ANVIL_USE);
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

