/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.interfaces.CubeletDateComparator;
import me.davidml16.acubelets.interfaces.CubeletTypeComparator;
import me.davidml16.acubelets.menus.player.LootHistoryMenu;
import me.davidml16.acubelets.menus.player.PlayerAnimationMenu;
import me.davidml16.acubelets.menus.player.crafting.CraftingMenu;
import me.davidml16.acubelets.menus.player.gifts.GiftPlayerMenu;
import me.davidml16.acubelets.menus.player.rewards.RewardsPreviewMenu;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.MessageUtils;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.TimeAPI.TimeUtils;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CubeletsMenu
extends Menu {
    public CubeletsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        ItemStack itemStack;
        int n2;
        Player player = this.getOwner();
        Profile profile = this.getMain().getPlayerDataHandler().getData(player.getUniqueId());
        List<Cubelet> list = profile.getCubelets();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("opencubelet");
        if (profile.getOrderBy().equalsIgnoreCase("date")) {
            list.sort(new CubeletDateComparator());
        } else if (profile.getOrderBy().equalsIgnoreCase("type")) {
            list.sort(new CubeletTypeComparator());
        }
        int n3 = this.getPageSize(gUILayout);
        if (n < 0) {
            this.openPage(0);
            return;
        }
        if (n > 0 && list.size() < n * n3 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > n3) {
            list = list.subList(n * n3, Math.min(n * n3 + n3, list.size()));
        }
        int n4 = this.getNeededSize(gUILayout, list.size());
        Inventory inventory = this.createInventory(n4, gUILayout.getMessage("Title"));
        if (n > 0) {
            n2 = gUILayout.getBoolean("Items.PreviousPage.ShowPageNumber") ? n : 1;
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PreviousPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.PreviousPage.Name")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "previous", "action");
            if (gUILayout.getSlot("PreviousPage") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("PreviousPage"), itemStack);
            }
        }
        if (this.getMain().getPlayerDataHandler().getData(player.getUniqueId()).getCubelets().size() > (n + 1) * n3) {
            n2 = gUILayout.getBoolean("Items.NextPage.ShowPageNumber") ? n + 2 : 1;
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NextPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.NextPage.Name")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "next", "action");
            if (gUILayout.getSlot("NextPage") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("NextPage"), itemStack);
            }
        }
        if (this.getMain().isCraftingEnabled()) {
            ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Crafting.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Crafting.Name")).setLore(gUILayout.getMessageList("Items.Crafting.Lore")).toItemStack();
            itemStack2 = NBTEditor.set(itemStack2, "crafting", "action");
            if (gUILayout.getBoolean("Items.Crafting.Enabled") && gUILayout.getSlot("Crafting") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("Crafting"), itemStack2);
            }
        }
        if (this.getMain().isAnimationByPlayer()) {
            ItemStack itemStack3 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Animations.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Animations.Name")).setLore(gUILayout.getMessageList("Items.Animations.Lore")).toItemStack();
            itemStack3 = NBTEditor.set(itemStack3, "animations", "action");
            if (gUILayout.getBoolean("Items.Animations.Enabled") && gUILayout.getSlot("Animations") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("Animations"), itemStack3);
            }
        }
        ItemStack itemStack4 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Close.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Close.Name")).setLore(gUILayout.getMessageList("Items.Close.Lore")).toItemStack();
        itemStack4 = NBTEditor.set(itemStack4, "close", "action");
        if (gUILayout.getBoolean("Items.Close.Enabled") && gUILayout.getSlot("Close") >= 0) {
            inventory.setItem(n4 - 10 + gUILayout.getSlot("Close"), itemStack4);
        }
        itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.LootHistory.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.LootHistory.Name")).setLore(gUILayout.getMessageList("Items.LootHistory.Lore")).toItemStack();
        itemStack = NBTEditor.set(itemStack, "loothistory", "action");
        if (gUILayout.getBoolean("Items.LootHistory.Enabled") && gUILayout.getSlot("LootHistory") >= 0) {
            inventory.setItem(n4 - 10 + gUILayout.getSlot("LootHistory"), itemStack);
        }
        if (this.getMain().isGiftCubelets()) {
            ItemStack itemStack5 = new ItemBuilder(SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNlZjlhYTE0ZTg4NDc3M2VhYzEzNGE0ZWU4OTcyMDYzZjQ2NmRlNjc4MzYzY2Y3YjFhMjFhODViNyJ9fX0=")).setName(gUILayout.getMessage("Items.Gift.Name")).setLore(gUILayout.getMessageList("Items.Gift.Lore")).toItemStack();
            itemStack5 = NBTEditor.set(itemStack5, "gift", "action");
            if (gUILayout.getBoolean("Items.Gift.Enabled") && gUILayout.getSlot("Gift") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("Gift"), itemStack5);
            }
        }
        for (int i = 0; i <= n4 - 10; ++i) {
            inventory.setItem(i, null);
        }
        if (this.getMain().getCubeletTypesHandler().getTypes().size() > 1) {
            if (gUILayout.getBoolean("Items.Ordered.Enabled")) {
                if (profile.getOrderBy().equalsIgnoreCase("date")) {
                    ItemStack itemStack6 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Ordered.Date.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Ordered.Date.Name")).setLore(gUILayout.getMessageList("Items.Ordered.Date.Lore")).toItemStack();
                    itemStack6 = NBTEditor.set(itemStack6, "ordered", "action");
                    inventory.setItem(n4 - 10 + gUILayout.getSlot("Ordered"), itemStack6);
                } else if (profile.getOrderBy().equalsIgnoreCase("type")) {
                    ItemStack itemStack7 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Ordered.Type.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Ordered.Type.Name")).setLore(gUILayout.getMessageList("Items.Ordered.Type.Lore")).toItemStack();
                    itemStack7 = NBTEditor.set(itemStack7, "ordered", "action");
                    inventory.setItem(n4 - 10 + gUILayout.getSlot("Ordered"), itemStack7);
                }
            } else {
                list.sort(new CubeletDateComparator());
            }
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (list.size() > 0) {
            for (Cubelet cubelet : list) {
                CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(cubelet.getType());
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (cubelet.getExpire() > System.currentTimeMillis()) {
                    for (String string : cubeletType.getLoreAvailable()) {
                        arrayList2.add(Utils.translate(string.replaceAll("%received%", TimeUtils.millisToLongDHMS(System.currentTimeMillis() - cubelet.getReceived()))).replaceAll("%expires%", TimeUtils.millisToLongDHMS(cubelet.getExpire() - System.currentTimeMillis())));
                    }
                } else {
                    for (String string : cubeletType.getLoreExpired()) {
                        arrayList2.add(Utils.translate(string.replaceAll("%received%", TimeUtils.millisToLongDHMS(System.currentTimeMillis() - cubelet.getReceived()))));
                    }
                }
                ItemStack itemStack8 = new ItemBuilder(cubeletType.getIcon()).setName(Utils.translate(cubeletType.getName())).setLore(arrayList2).toItemStack();
                itemStack8 = NBTEditor.set(itemStack8, cubelet.getUuid().toString(), "cubeletUUID");
                itemStack8 = NBTEditor.set(itemStack8, cubeletType.getId(), "typeID");
                inventory.addItem(new ItemStack[]{itemStack8});
                arrayList.add(itemStack8);
            }
        } else {
            int n5 = 0;
            if (!gUILayout.getBoolean("Size.Dynamic") && gUILayout.getSlot("NoCubelets") <= n4 - 10) {
                n5 = gUILayout.getSlot("NoCubelets");
            }
            inventory.setItem(n5, new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NoCubelets.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.NoCubelets.Name")).setLore(gUILayout.getMessageList("Items.NoCubelets.Lore")).toItemStack());
        }
        this.openInventory();
        this.setAttribute(Menu.AttrType.CUBELET_DISPLAYED_LIST_ATTR, list);
        this.setAttribute(Menu.AttrType.CUBELET_DISPLAYED_ITEMS_ATTR, arrayList);
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        int n2 = player.getOpenInventory().getTopInventory().getSize();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("opencubelet");
        if (n >= n2 - 9 && n <= n2) {
            String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
            if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (string == null) {
                return;
            }
            switch (string) {
                case "previous": {
                    this.previousPage();
                    break;
                }
                case "next": {
                    this.nextPage();
                    break;
                }
                case "close": {
                    player.closeInventory();
                    break;
                }
                case "ordered": {
                    Profile profile = this.getMain().getPlayerDataHandler().getData(player.getUniqueId());
                    if (profile.getOrderBy().equalsIgnoreCase("date")) {
                        profile.setOrderBy("type");
                    } else if (profile.getOrderBy().equalsIgnoreCase("type")) {
                        profile.setOrderBy("date");
                    }
                    this.reloadMyMenu();
                    break;
                }
                case "crafting": {
                    new CraftingMenu(this.getMain(), player).open();
                    break;
                }
                case "loothistory": {
                    LootHistoryMenu lootHistoryMenu = new LootHistoryMenu(this.getMain(), player);
                    lootHistoryMenu.setAttribute(Menu.AttrType.OPENED_EXTERNALLY_ATTR, Boolean.FALSE);
                    lootHistoryMenu.open();
                    break;
                }
                case "animations": {
                    new PlayerAnimationMenu(this.getMain(), player).open();
                    break;
                }
                case "gift": {
                    new GiftPlayerMenu(this.getMain(), player).open();
                }
            }
        } else if (n >= 0 && n <= player.getOpenInventory().getTopInventory().getSize() - 10) {
            if (this.getMain().getPlayerDataHandler().getData(player.getUniqueId()).getCubelets().size() > 0) {
                String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "cubeletUUID");
                String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "typeID");
                CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string2);
                if (inventoryClickEvent.getClick() != this.getMain().getMenuHandler().getRewardPreviewClickType()) {
                    Profile profile = this.getMain().getPlayerDataHandler().getData(player);
                    if (profile.getBoxOpened().isWaiting()) {
                        Optional<Cubelet> optional = profile.getCubelets().stream().filter(cubelet -> cubelet.getUuid().toString().equalsIgnoreCase(string)).findFirst();
                        if (optional.isPresent() && optional.get().getExpire() > System.currentTimeMillis() && cubeletType.getAllRewards().size() > 0) {
                            this.getMain().getCubeletOpenHandler().openAnimation(player, profile.getBoxOpened(), cubeletType, false);
                            profile.getCubelets().removeIf(cubelet -> cubelet.getUuid().toString().equals(string));
                            this.getMain().getDatabaseHandler().removeCubelet(player.getUniqueId(), UUID.fromString(Objects.requireNonNull(string)));
                            this.getMain().getHologramImplementation().reloadHolograms(player);
                            player.closeInventory();
                        }
                    } else if (profile.getBoxOpened().getPlayerOpening().getUuid() == player.getUniqueId()) {
                        player.sendMessage(this.getMain().getLanguageHandler().getMessage("Cubelet.BoxInUse.Me"));
                    } else {
                        player.sendMessage(this.getMain().getLanguageHandler().getMessage("Cubelet.BoxInUse.Other").replaceAll("%player%", profile.getBoxOpened().getPlayerOpening().getName()));
                    }
                } else if (inventoryClickEvent.getClick() == this.getMain().getMenuHandler().getRewardPreviewClickType() && this.getMain().isPreviewEnabled()) {
                    RewardsPreviewMenu rewardsPreviewMenu = new RewardsPreviewMenu(Main.get(), player);
                    rewardsPreviewMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, string2);
                    rewardsPreviewMenu.setAttribute(Menu.AttrType.OPENED_EXTERNALLY_ATTR, Boolean.FALSE);
                    rewardsPreviewMenu.open();
                    return;
                }
            } else {
                int n3 = 0;
                if (!gUILayout.getBoolean("Size.Dynamic") && gUILayout.getSlot("NoCubelets") <= this.getPageSize(gUILayout)) {
                    n3 = gUILayout.getSlot("NoCubelets");
                }
                if (n == n3) {
                    player.closeInventory();
                    MessageUtils.sendShopMessage(player);
                }
            }
        }
        player.updateInventory();
    }

    @Override
    public void OnMenuClosed() {
    }

    private int getNeededSize(GUILayout gUILayout, int n) {
        int n2 = 0;
        int n3 = gUILayout.getInteger("Size.Max-Cubelets-Rows");
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > 5) {
            n3 = 5;
        }
        if (gUILayout.getBoolean("Size.Dynamic")) {
            n2 = n > 36 ? 5 : n / 9 + (n == 0 ? 1 : (n % 9 != 0 ? 1 : 0));
            n2 = Math.min(n2, n3);
        } else {
            n2 = n3;
        }
        return (n2 + 1) * 9;
    }

    private int getPageSize(GUILayout gUILayout) {
        int n = gUILayout.getInteger("Size.Max-Cubelets-Rows");
        if (n < 1) {
            n = 1;
        } else if (n > 5) {
            n = 5;
        }
        return n * 9;
    }
}

