/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.awt.Color;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.davidml16.acubelets.utils.Regex.RegexUtils;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

public class Colorizer {
    public static final Pattern PATTERN_HEX = Pattern.compile("#([A-Fa-f0-9]{6})");
    public static final Pattern PATTERN_GRADIENT = Pattern.compile("<gradient:" + PATTERN_HEX.pattern() + ">(.*?)</gradient:" + PATTERN_HEX.pattern() + ">");

    @NotNull
    public static String apply(@NotNull String string) {
        return Colorizer.hex(Colorizer.gradient(Colorizer.legacy(string)));
    }

    @NotNull
    public static List<String> apply(@NotNull List<String> list) {
        list.replaceAll(Colorizer::apply);
        return list;
    }

    @NotNull
    public static Set<String> apply(@NotNull Set<String> set) {
        return set.stream().map(Colorizer::apply).collect(Collectors.toSet());
    }

    @NotNull
    public static String legacyHex(@NotNull String string) {
        return Colorizer.hex(Colorizer.legacy(string));
    }

    @NotNull
    public static String legacy(@NotNull String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    @NotNull
    public static String hex(@NotNull String string) {
        Matcher matcher = PATTERN_HEX.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        while (RegexUtils.matcherFind(matcher)) {
            String string2 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, "\u00a7x\u00a7" + string2.charAt(0) + '\u00a7' + string2.charAt(1) + '\u00a7' + string2.charAt(2) + '\u00a7' + string2.charAt(3) + '\u00a7' + string2.charAt(4) + '\u00a7' + string2.charAt(5));
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    private static ChatColor[] createGradient(@NotNull Color color, @NotNull Color color2, int n) {
        ChatColor[] chatColorArray = new ChatColor[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)n;
            int n2 = (int)((double)color.getRed() + d * (double)(color2.getRed() - color.getRed()));
            int n3 = (int)((double)color.getGreen() + d * (double)(color2.getGreen() - color.getGreen()));
            int n4 = (int)((double)color.getBlue() + d * (double)(color2.getBlue() - color.getBlue()));
            Color color3 = new Color(n2, n3, n4);
        }
        return chatColorArray;
    }

    @NotNull
    public static String gradient(@NotNull String string) {
        Matcher matcher = PATTERN_GRADIENT.matcher(string);
        while (RegexUtils.matcherFind(matcher)) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            String string4 = matcher.group(2);
            Color color = new Color(Integer.parseInt(string2, 16));
            Color color2 = new Color(Integer.parseInt(string3, 16));
            ChatColor[] chatColorArray = Colorizer.createGradient(color, color2, Colorizer.strip(string4).length());
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            char[] cArray = string4.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\u00a7') {
                    if (i + 1 < cArray.length) {
                        if (cArray[i + 1] == 'r') {
                            stringBuilder2.setLength(0);
                        } else {
                            stringBuilder2.append(cArray[i]);
                            stringBuilder2.append(cArray[i + 1]);
                        }
                        ++i;
                        continue;
                    }
                    stringBuilder.append(chatColorArray[n++]).append((CharSequence)stringBuilder2).append(cArray[i]);
                    continue;
                }
                stringBuilder.append(chatColorArray[n++]).append((CharSequence)stringBuilder2).append(cArray[i]);
            }
            string = string.replace(matcher.group(0), stringBuilder.toString());
        }
        return string;
    }

    @NotNull
    public static String plain(@NotNull String string) {
        return Colorizer.plainLegacy(Colorizer.plainHex(string));
    }

    @NotNull
    public static String plainLegacy(@NotNull String string) {
        return string.replace('\u00a7', '&');
    }

    @NotNull
    public static String plainHex(@NotNull String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.toString().indexOf("\u00a7x")) >= 0) {
            int n2 = 0;
            stringBuilder.replace(n, n + 2, "#");
            int n3 = n + 1;
            while (n2 < 6) {
                stringBuilder.deleteCharAt(n3);
                ++n2;
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String strip(@NotNull String string) {
        String string2 = ChatColor.stripColor((String)string);
        return string2 == null ? "" : string2;
    }

    @NotNull
    public static String restrip(@NotNull String string) {
        return Colorizer.strip(Colorizer.apply(string));
    }
}

