/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static final int CENTER_PX = 154;

    public static String centeredMessage(String string) {
        String[] stringArray = ChatColor.translateAlternateColorCodes((char)'&', (String)string).split("\n", 40);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            for (char c : string2.toCharArray()) {
                if (c == '\u00a7') {
                    bl = true;
                    continue;
                }
                if (bl) {
                    bl = false;
                    bl2 = c == 'l';
                    continue;
                }
                DefaultFontInfo defaultFontInfo = DefaultFontInfo.getDefaultFontInfo(c);
                n = bl2 ? n + defaultFontInfo.getBoldLength() : n + defaultFontInfo.getLength();
                ++n;
            }
            int n2 = 154 - n / 2;
            int n3 = DefaultFontInfo.SPACE.getLength() + 1;
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < n2; i += n3) {
                stringBuilder2.append(" ");
            }
            stringBuilder.append(stringBuilder2.toString()).append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void sendLootMessage(CubeletMachine cubeletMachine, CubeletType cubeletType, Reward reward) {
        Player player = Bukkit.getPlayer((UUID)cubeletMachine.getPlayerOpening().getUuid());
        if (player != null) {
            if (!Main.get().isDuplicationEnabled()) {
                MessageUtils.newLootMessage(player, cubeletType, reward);
            } else if (!Main.get().getCubeletRewardHandler().isDuplicated(cubeletMachine, reward)) {
                MessageUtils.newLootMessage(player, cubeletType, reward);
            } else if (Main.get().isDuplicationEnabled() && Main.get().getCubeletRewardHandler().isDuplicated(cubeletMachine, reward)) {
                MessageUtils.duplicateLootMessage(player, cubeletType, reward, cubeletMachine.getLastDuplicationPoints());
            }
        }
    }

    private static void newLootMessage(Player player, CubeletType cubeletType, Reward reward) {
        for (String string : Main.get().getLanguageHandler().getMessageList("Cubelet.Reward.New")) {
            if (string.contains("%center%")) {
                string = string.replaceAll("%center%", "");
                player.sendMessage(MessageUtils.centeredMessage(Utils.translate(string.replaceAll("%cubelet_type%", Matcher.quoteReplacement(cubeletType.getName())).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName())))));
                continue;
            }
            player.sendMessage(Utils.translate(string.replaceAll("%cubelet_type%", Matcher.quoteReplacement(cubeletType.getName())).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName()))));
        }
    }

    private static void duplicateLootMessage(Player player, CubeletType cubeletType, Reward reward, int n) {
        if (n <= 0) {
            MessageUtils.newLootMessage(player, cubeletType, reward);
            return;
        }
        for (String string : Main.get().getLanguageHandler().getMessageList("Cubelet.Reward.Duplicate")) {
            if (string.contains("%center%")) {
                string = string.replaceAll("%center%", "");
                player.sendMessage(MessageUtils.centeredMessage(Utils.translate(string.replaceAll("%cubelet_type%", Matcher.quoteReplacement(cubeletType.getName())).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName())).replaceAll("%points%", "" + n))));
                continue;
            }
            player.sendMessage(Utils.translate(string.replaceAll("%cubelet_type%", Matcher.quoteReplacement(cubeletType.getName())).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName())).replaceAll("%points%", "" + n)));
        }
    }

    public static void sendShopMessage(Player player) {
        if (player != null) {
            if (Main.get().isCubeletsCommandEnabled()) {
                switch (Main.get().getNoCubeletsCommandExecutor()) {
                    case "player": {
                        player.chat("/" + Main.get().getNoCubeletsCommand());
                        break;
                    }
                    case "console": {
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), Main.get().getNoCubeletsCommand().replaceAll("%player%", player.getName()));
                    }
                }
            } else {
                for (String string : Main.get().getLanguageHandler().getMessageList("Cubelet.NoCubelets")) {
                    if (string.contains("%center%")) {
                        string = string.replaceAll("%center%", "");
                        player.sendMessage(MessageUtils.centeredMessage(Utils.translate(string)));
                        continue;
                    }
                    player.sendMessage(Utils.translate(string));
                }
            }
        }
    }

    public static void sendBroadcastMessage(Main main, CubeletMachine cubeletMachine, CubeletType cubeletType, Reward reward) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "Cubelet.Reward.Broadcast";
        FileConfiguration fileConfiguration = main.getLanguageHandler().getConfig();
        if (fileConfiguration.get(string) instanceof ArrayList) {
            arrayList.addAll(main.getLanguageHandler().getMessageList(string));
        } else {
            arrayList.add(main.getLanguageHandler().getMessage(string));
        }
        for (String string2 : arrayList) {
            string2 = string2.replaceAll("%player%", Matcher.quoteReplacement(cubeletMachine.getPlayerOpening().getName()));
            string2 = string2.replaceAll("%reward%", Matcher.quoteReplacement(Utils.getColorByText(reward.getRarity().getName()) + reward.getName()));
            if ((string2 = string2.replaceAll("%cubelet%", Matcher.quoteReplacement(reward.getParentCubelet().getName()))).contains("%center%")) {
                string2 = string2.replaceAll("%center%", "");
                main.getServer().broadcastMessage(MessageUtils.centeredMessage(Utils.translate(string2)));
                continue;
            }
            main.getServer().broadcastMessage(Utils.translate(string2));
        }
    }

    public static enum DefaultFontInfo {
        A('A', 5),
        a('a', 5),
        B('B', 5),
        b('b', 5),
        C('C', 5),
        c('c', 5),
        D('D', 5),
        d('d', 5),
        E('E', 5),
        e('e', 5),
        F('F', 5),
        f('f', 4),
        G('G', 5),
        g('g', 5),
        H('H', 5),
        h('h', 5),
        I('I', 3),
        i('i', 1),
        J('J', 5),
        j('j', 5),
        K('K', 5),
        k('k', 4),
        L('L', 5),
        l('l', 1),
        M('M', 5),
        m('m', 5),
        N('N', 5),
        n('n', 5),
        O('O', 5),
        o('o', 5),
        P('P', 5),
        p('p', 5),
        Q('Q', 5),
        q('q', 5),
        R('R', 5),
        r('r', 5),
        S('S', 5),
        s('s', 5),
        T('T', 5),
        t('t', 4),
        U('U', 5),
        u('u', 5),
        V('V', 5),
        v('v', 5),
        W('W', 5),
        w('w', 5),
        X('X', 5),
        x('x', 5),
        Y('Y', 5),
        y('y', 5),
        Z('Z', 5),
        z('z', 5),
        NUM_1('1', 5),
        NUM_2('2', 5),
        NUM_3('3', 5),
        NUM_4('4', 5),
        NUM_5('5', 5),
        NUM_6('6', 5),
        NUM_7('7', 5),
        NUM_8('8', 5),
        NUM_9('9', 5),
        NUM_0('0', 5),
        EXCLAMATION_POINT('!', 1),
        AT_SYMBOL('@', 6),
        NUM_SIGN('#', 5),
        DOLLAR_SIGN('$', 5),
        PERCENT('%', 5),
        UP_ARROW('^', 5),
        AMPERSAND('&', 5),
        ASTERISK('*', 5),
        LEFT_PARENTHESIS('(', 4),
        RIGHT_PERENTHESIS(')', 4),
        MINUS('-', 5),
        UNDERSCORE('_', 5),
        PLUS_SIGN('+', 5),
        EQUALS_SIGN('=', 5),
        LEFT_CURL_BRACE('{', 4),
        RIGHT_CURL_BRACE('}', 4),
        LEFT_BRACKET('[', 3),
        RIGHT_BRACKET(']', 3),
        COLON(':', 1),
        SEMI_COLON(';', 1),
        DOUBLE_QUOTE('\"', 3),
        SINGLE_QUOTE('\'', 1),
        LEFT_ARROW('<', 4),
        RIGHT_ARROW('>', 4),
        QUESTION_MARK('?', 5),
        SLASH('/', 5),
        BACK_SLASH('\\', 5),
        LINE('|', 1),
        TILDE('~', 5),
        TICK('`', 2),
        PERIOD('.', 1),
        COMMA(',', 1),
        SPACE(' ', 3),
        DEFAULT('a', 4);

        private char character;
        private int length;

        private DefaultFontInfo(char c, int n2) {
            this.character = c;
            this.length = n2;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getLength() {
            return this.length;
        }

        public int getBoldLength() {
            if (this == SPACE) {
                return this.getLength();
            }
            return this.length + 1;
        }

        public static DefaultFontInfo getDefaultFontInfo(char c) {
            for (DefaultFontInfo defaultFontInfo : DefaultFontInfo.values()) {
                if (defaultFontInfo.getCharacter() != c) continue;
                return defaultFontInfo;
            }
            return DEFAULT;
        }
    }
}

