/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.Regex;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.davidml16.acubelets.utils.Regex.MatcherTimeoutException;
import me.davidml16.acubelets.utils.Regex.TimeoutCharSequence;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class RegexUtils {
    public static final Pattern PATTERN_EN = Pattern.compile("[a-zA-Z0-9_]*");
    @Deprecated
    public static final Pattern PATTERN_RU = Pattern.compile("[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_]*");
    public static final Pattern PATTERN_IP = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");

    public static boolean matchesEn(@NotNull String string) {
        return RegexUtils.matches(PATTERN_EN, string);
    }

    @Deprecated
    public static boolean matchesEnRu(@NotNull String string) {
        return RegexUtils.matches(PATTERN_RU, string);
    }

    public static boolean isIpAddress(@NotNull String string) {
        return RegexUtils.matches(PATTERN_IP, string);
    }

    public static boolean matches(@NotNull Pattern pattern, @NotNull String string) {
        Matcher matcher = RegexUtils.getMatcher(pattern, string);
        return matcher.matches();
    }

    @NotNull
    public static Matcher getMatcher(@NotNull String string, @NotNull String string2) {
        return RegexUtils.getMatcher(string, string2, 200L);
    }

    @NotNull
    public static Matcher getMatcher(@NotNull String string, @NotNull String string2, long l) {
        Pattern pattern = Pattern.compile(string);
        return RegexUtils.getMatcher(pattern, string2, l);
    }

    @NotNull
    public static Matcher getMatcher(@NotNull Pattern pattern, @NotNull String string) {
        return RegexUtils.getMatcher(pattern, string, 200L);
    }

    public static boolean matcherFind(@NotNull Matcher matcher) {
        try {
            return matcher.find();
        }
        catch (MatcherTimeoutException matcherTimeoutException) {
            Bukkit.getLogger().log(Level.SEVERE, "Matcher timeout error: '" + matcher.pattern().pattern() + "' (" + matcherTimeoutException.getTimeout() + "ms)");
            return false;
        }
    }

    @NotNull
    public static Matcher getMatcher(@NotNull Pattern pattern, @NotNull String string, long l) {
        if (l <= 0L) {
            return pattern.matcher(string);
        }
        return pattern.matcher(new TimeoutCharSequence(string, l));
    }
}

