/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;

public class Document
extends Element {
    @Nullable
    private Connection connection;
    private OutputSettings outputSettings = new OutputSettings();
    private Parser parser;
    private QuirksMode quirksMode = QuirksMode.noQuirks;
    private final String location;
    private boolean updateMetaCharset = false;
    private static final Evaluator titleEval = new Evaluator.Tag("title");

    public Document(String string) {
        super(Tag.valueOf("#root", ParseSettings.htmlDefault), string);
        this.location = string;
        this.parser = Parser.htmlParser();
    }

    public static Document createShell(String string) {
        Validate.notNull(string);
        Document document = new Document(string);
        document.parser = document.parser();
        Element element = document.appendElement("html");
        element.appendElement("head");
        element.appendElement("body");
        return document;
    }

    public String location() {
        return this.location;
    }

    public Connection connection() {
        if (this.connection == null) {
            return Jsoup.newSession();
        }
        return this.connection;
    }

    @Nullable
    public DocumentType documentType() {
        for (Node node : this.childNodes) {
            if (node instanceof DocumentType) {
                return (DocumentType)node;
            }
            if (node instanceof LeafNode) continue;
            break;
        }
        return null;
    }

    private Element htmlEl() {
        for (Element element : this.childElementsList()) {
            if (!element.normalName().equals("html")) continue;
            return element;
        }
        return this.appendElement("html");
    }

    public Element head() {
        Element element = this.htmlEl();
        for (Element element2 : element.childElementsList()) {
            if (!element2.normalName().equals("head")) continue;
            return element2;
        }
        return element.prependElement("head");
    }

    public Element body() {
        Element element = this.htmlEl();
        for (Element element2 : element.childElementsList()) {
            if (!"body".equals(element2.normalName()) && !"frameset".equals(element2.normalName())) continue;
            return element2;
        }
        return element.appendElement("body");
    }

    public String title() {
        Element element = this.head().selectFirst(titleEval);
        return element != null ? StringUtil.normaliseWhitespace(element.text()).trim() : "";
    }

    public void title(String string) {
        Validate.notNull(string);
        Element element = this.head().selectFirst(titleEval);
        if (element == null) {
            element = this.head().appendElement("title");
        }
        element.text(string);
    }

    public Element createElement(String string) {
        return new Element(Tag.valueOf(string, ParseSettings.preserveCase), this.baseUri());
    }

    public Document normalise() {
        Element element = this.htmlEl();
        Element element2 = this.head();
        this.body();
        this.normaliseTextNodes(element2);
        this.normaliseTextNodes(element);
        this.normaliseTextNodes(this);
        this.normaliseStructure("head", element);
        this.normaliseStructure("body", element);
        this.ensureMetaCharsetElement();
        return this;
    }

    private void normaliseTextNodes(Element element) {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        for (Node node : element.childNodes) {
            TextNode textNode;
            if (!(node instanceof TextNode) || (textNode = (TextNode)node).isBlank()) continue;
            arrayList.add(textNode);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Node node;
            node = (Node)arrayList.get(i);
            element.removeChild(node);
            this.body().prependChild(new TextNode(" "));
            this.body().prependChild(node);
        }
    }

    private void normaliseStructure(String string, Element element) {
        Elements elements = this.getElementsByTag(string);
        Element element2 = elements.first();
        if (elements.size() > 1) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 1; i < elements.size(); ++i) {
                Node node = (Node)elements.get(i);
                arrayList.addAll(node.ensureChildNodes());
                node.remove();
            }
            for (Node node : arrayList) {
                element2.appendChild(node);
            }
        }
        if (element2.parent() != null && !element2.parent().equals(element)) {
            element.appendChild(element2);
        }
    }

    @Override
    public String outerHtml() {
        return super.html();
    }

    @Override
    public Element text(String string) {
        this.body().text(string);
        return this;
    }

    @Override
    public String nodeName() {
        return "#document";
    }

    public void charset(Charset charset) {
        this.updateMetaCharsetElement(true);
        this.outputSettings.charset(charset);
        this.ensureMetaCharsetElement();
    }

    public Charset charset() {
        return this.outputSettings.charset();
    }

    public void updateMetaCharsetElement(boolean bl) {
        this.updateMetaCharset = bl;
    }

    public boolean updateMetaCharsetElement() {
        return this.updateMetaCharset;
    }

    @Override
    public Document clone() {
        Document document = (Document)super.clone();
        document.outputSettings = this.outputSettings.clone();
        return document;
    }

    @Override
    public Document shallowClone() {
        Document document = new Document(this.baseUri());
        if (this.attributes != null) {
            document.attributes = this.attributes.clone();
        }
        document.outputSettings = this.outputSettings.clone();
        return document;
    }

    private void ensureMetaCharsetElement() {
        if (this.updateMetaCharset) {
            OutputSettings.Syntax syntax = this.outputSettings().syntax();
            if (syntax == OutputSettings.Syntax.html) {
                Element element = this.selectFirst("meta[charset]");
                if (element != null) {
                    element.attr("charset", this.charset().displayName());
                } else {
                    this.head().appendElement("meta").attr("charset", this.charset().displayName());
                }
                this.select("meta[name=charset]").remove();
            } else if (syntax == OutputSettings.Syntax.xml) {
                Node node = this.ensureChildNodes().get(0);
                if (node instanceof XmlDeclaration) {
                    XmlDeclaration xmlDeclaration = (XmlDeclaration)node;
                    if (xmlDeclaration.name().equals("xml")) {
                        xmlDeclaration.attr("encoding", this.charset().displayName());
                        if (xmlDeclaration.hasAttr("version")) {
                            xmlDeclaration.attr("version", "1.0");
                        }
                    } else {
                        xmlDeclaration = new XmlDeclaration("xml", false);
                        xmlDeclaration.attr("version", "1.0");
                        xmlDeclaration.attr("encoding", this.charset().displayName());
                        this.prependChild(xmlDeclaration);
                    }
                } else {
                    XmlDeclaration xmlDeclaration = new XmlDeclaration("xml", false);
                    xmlDeclaration.attr("version", "1.0");
                    xmlDeclaration.attr("encoding", this.charset().displayName());
                    this.prependChild(xmlDeclaration);
                }
            }
        }
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public Document outputSettings(OutputSettings outputSettings) {
        Validate.notNull(outputSettings);
        this.outputSettings = outputSettings;
        return this;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    public Document quirksMode(QuirksMode quirksMode) {
        this.quirksMode = quirksMode;
        return this;
    }

    public Parser parser() {
        return this.parser;
    }

    public Document parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public Document connection(Connection connection) {
        Validate.notNull(connection);
        this.connection = connection;
        return this;
    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset = DataUtil.UTF_8;
        private final ThreadLocal<CharsetEncoder> encoderThreadLocal = new ThreadLocal();
        @Nullable
        Entities.CoreCharset coreCharset;
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;
        private int maxPaddingWidth = 30;
        private Syntax syntax = Syntax.html;

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            this.escapeMode = escapeMode;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public OutputSettings charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public OutputSettings charset(String string) {
            this.charset(Charset.forName(string));
            return this;
        }

        CharsetEncoder prepareEncoder() {
            CharsetEncoder charsetEncoder = this.charset.newEncoder();
            this.encoderThreadLocal.set(charsetEncoder);
            this.coreCharset = Entities.CoreCharset.byName(charsetEncoder.charset().name());
            return charsetEncoder;
        }

        CharsetEncoder encoder() {
            CharsetEncoder charsetEncoder = this.encoderThreadLocal.get();
            return charsetEncoder != null ? charsetEncoder : this.prepareEncoder();
        }

        public Syntax syntax() {
            return this.syntax;
        }

        public OutputSettings syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        public OutputSettings prettyPrint(boolean bl) {
            this.prettyPrint = bl;
            return this;
        }

        public boolean outline() {
            return this.outline;
        }

        public OutputSettings outline(boolean bl) {
            this.outline = bl;
            return this;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        public OutputSettings indentAmount(int n) {
            Validate.isTrue(n >= 0);
            this.indentAmount = n;
            return this;
        }

        public int maxPaddingWidth() {
            return this.maxPaddingWidth;
        }

        public OutputSettings maxPaddingWidth(int n) {
            Validate.isTrue(n >= -1);
            this.maxPaddingWidth = n;
            return this;
        }

        public OutputSettings clone() {
            OutputSettings outputSettings;
            try {
                outputSettings = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            outputSettings.charset(this.charset.name());
            outputSettings.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return outputSettings;
        }

        public static enum Syntax {
            html,
            xml;

        }
    }

    public static enum QuirksMode {
        noQuirks,
        quirks,
        limitedQuirks;

    }
}

