/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String string, Attributes attributes) {
        super(tag, string, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    @Override
    protected void removeChild(Node node) {
        super.removeChild(node);
        this.elements.remove(node);
    }

    public Connection submit() {
        String string = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(string, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").equalsIgnoreCase("POST") ? Connection.Method.POST : Connection.Method.GET;
        Document document = this.ownerDocument();
        Connection connection = document != null ? document.connection().newRequest() : Jsoup.newSession();
        return connection.url(string).data(this.formData()).method(method);
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> arrayList = new ArrayList<Connection.KeyVal>();
        for (Element element : this.elements) {
            Object object;
            String string;
            String string2;
            if (!element.tag().isFormSubmittable() || element.hasAttr("disabled") || (string2 = element.attr("name")).length() == 0 || (string = element.attr("type")).equalsIgnoreCase("button")) continue;
            if ("select".equals(element.normalName())) {
                object = element.select("option[selected]");
                boolean bl = false;
                Object object2 = ((ArrayList)object).iterator();
                while (object2.hasNext()) {
                    Element element2 = (Element)object2.next();
                    arrayList.add(HttpConnection.KeyVal.create(string2, element2.val()));
                    bl = true;
                }
                if (bl || (object2 = element.selectFirst("option")) == null) continue;
                arrayList.add(HttpConnection.KeyVal.create(string2, ((Element)object2).val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(string) || "radio".equalsIgnoreCase(string)) {
                if (!element.hasAttr("checked")) continue;
                object = element.val().length() > 0 ? element.val() : "on";
                arrayList.add(HttpConnection.KeyVal.create(string2, (String)object));
                continue;
            }
            arrayList.add(HttpConnection.KeyVal.create(string2, element.val()));
        }
        return arrayList;
    }

    @Override
    public FormElement clone() {
        return (FormElement)super.clone();
    }
}

