/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.List;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Node;

abstract class LeafNode
extends Node {
    Object value;

    LeafNode() {
    }

    @Override
    protected final boolean hasAttributes() {
        return this.value instanceof Attributes;
    }

    @Override
    public final Attributes attributes() {
        this.ensureAttributes();
        return (Attributes)this.value;
    }

    private void ensureAttributes() {
        if (!this.hasAttributes()) {
            Object object = this.value;
            Attributes attributes = new Attributes();
            this.value = attributes;
            if (object != null) {
                attributes.put(this.nodeName(), (String)object);
            }
        }
    }

    String coreValue() {
        return this.attr(this.nodeName());
    }

    void coreValue(String string) {
        this.attr(this.nodeName(), string);
    }

    @Override
    public String attr(String string) {
        if (!this.hasAttributes()) {
            return this.nodeName().equals(string) ? (String)this.value : "";
        }
        return super.attr(string);
    }

    @Override
    public Node attr(String string, String string2) {
        if (!this.hasAttributes() && string.equals(this.nodeName())) {
            this.value = string2;
        } else {
            this.ensureAttributes();
            super.attr(string, string2);
        }
        return this;
    }

    @Override
    public boolean hasAttr(String string) {
        this.ensureAttributes();
        return super.hasAttr(string);
    }

    @Override
    public Node removeAttr(String string) {
        this.ensureAttributes();
        return super.removeAttr(string);
    }

    @Override
    public String absUrl(String string) {
        this.ensureAttributes();
        return super.absUrl(string);
    }

    @Override
    public String baseUri() {
        return this.hasParent() ? this.parent().baseUri() : "";
    }

    @Override
    protected void doSetBaseUri(String string) {
    }

    @Override
    public int childNodeSize() {
        return 0;
    }

    @Override
    public Node empty() {
        return this;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        return EmptyNodes;
    }

    @Override
    protected LeafNode doClone(Node node) {
        LeafNode leafNode = (LeafNode)super.doClone(node);
        if (this.hasAttributes()) {
            leafNode.value = ((Attributes)this.value).clone();
        }
        return leafNode;
    }
}

