/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.bungeecord;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.platform.facet.FacetBase;
import net.kyori.adventure.platform.facet.FacetComponentFlattener;
import net.kyori.adventure.platform.facet.FacetPointers;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.TranslationRegistry;
import net.md_5.bungee.protocol.DefinedPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BungeeFacet<V extends CommandSender>
extends FacetBase<V> {
    static final BaseComponent[] EMPTY_COMPONENT_ARRAY = new BaseComponent[0];
    private static final Collection<? extends FacetComponentFlattener.Translator<ProxyServer>> TRANSLATORS = Facet.of(Translator::new);
    static final ComponentFlattener FLATTENER = FacetComponentFlattener.get(ProxyServer.getInstance(), TRANSLATORS);
    static final BungeeComponentSerializer MODERN = BungeeComponentSerializer.of(GsonComponentSerializer.gson(), LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().flattener(FLATTENER).build());
    static final BungeeComponentSerializer LEGACY = BungeeComponentSerializer.of(GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().build(), LegacyComponentSerializer.builder().flattener(FLATTENER).build());

    protected BungeeFacet(@Nullable Class<? extends V> clazz) {
        super(clazz);
    }

    static class Translator
    extends FacetBase<ProxyServer>
    implements FacetComponentFlattener.Translator<ProxyServer> {
        private static final boolean SUPPORTED;

        Translator() {
            super(ProxyServer.class);
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        @NotNull
        public String valueOrDefault(@NotNull ProxyServer proxyServer, @NotNull String string) {
            return TranslationRegistry.INSTANCE.translate(string);
        }

        static {
            boolean bl;
            try {
                Class.forName("net.md_5.bungee.chat.TranslationRegistry");
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            SUPPORTED = bl;
        }
    }

    static final class PlayerPointers
    extends BungeeFacet<ProxiedPlayer>
    implements Facet.Pointers<ProxiedPlayer> {
        PlayerPointers() {
            super(ProxiedPlayer.class);
        }

        @Override
        public void contributePointers(ProxiedPlayer proxiedPlayer, Pointers.Builder builder) {
            builder.withDynamic(Identity.UUID, () -> ((ProxiedPlayer)proxiedPlayer).getUniqueId());
            builder.withDynamic(Identity.LOCALE, () -> ((ProxiedPlayer)proxiedPlayer).getLocale());
            builder.withDynamic(FacetPointers.SERVER, () -> proxiedPlayer.getServer().getInfo().getName());
            builder.withStatic(FacetPointers.TYPE, FacetPointers.Type.PLAYER);
        }
    }

    static final class CommandSenderPointers
    extends BungeeFacet<CommandSender>
    implements Facet.Pointers<CommandSender> {
        CommandSenderPointers() {
            super(CommandSender.class);
        }

        @Override
        public void contributePointers(CommandSender commandSender, Pointers.Builder builder) {
            builder.withDynamic(Identity.NAME, () -> ((CommandSender)commandSender).getName());
            builder.withStatic(PermissionChecker.POINTER, string -> commandSender.hasPermission(string) ? TriState.TRUE : TriState.FALSE);
            if (!(commandSender instanceof ProxiedPlayer)) {
                builder.withStatic(FacetPointers.TYPE, commandSender == ProxyServer.getInstance().getConsole() ? FacetPointers.Type.CONSOLE : FacetPointers.Type.OTHER);
            }
        }
    }

    static final class TabList
    extends Message
    implements Facet.TabList<ProxiedPlayer, BaseComponent[]> {
        TabList() {
        }

        @Override
        public void send(ProxiedPlayer proxiedPlayer, BaseComponent @Nullable [] baseComponentArray, BaseComponent @Nullable [] baseComponentArray2) {
            proxiedPlayer.setTabHeader(baseComponentArray == null ? EMPTY_COMPONENT_ARRAY : baseComponentArray, baseComponentArray2 == null ? EMPTY_COMPONENT_ARRAY : baseComponentArray2);
        }
    }

    static class BossBar
    extends Message
    implements Facet.BossBarPacket<ProxiedPlayer> {
        private final Set<ProxiedPlayer> viewers;
        private final net.md_5.bungee.protocol.packet.BossBar bar;
        private volatile boolean initialized = false;

        protected BossBar(@NotNull Collection<ProxiedPlayer> collection) {
            this.viewers = new CopyOnWriteArraySet<ProxiedPlayer>(collection);
            this.bar = new net.md_5.bungee.protocol.packet.BossBar(UUID.randomUUID(), 0);
        }

        @Override
        public void bossBarInitialized(@NotNull net.kyori.adventure.bossbar.BossBar bossBar) {
            Facet.BossBarPacket.super.bossBarInitialized(bossBar);
            this.initialized = true;
            this.broadcastPacket(0);
        }

        @Override
        public void bossBarNameChanged(@NotNull net.kyori.adventure.bossbar.BossBar bossBar, @NotNull Component component, @NotNull Component component2) {
            if (!this.viewers.isEmpty()) {
                this.bar.setTitle(ComponentSerializer.toString((BaseComponent[])this.createMessage(this.viewers.iterator().next(), component2)));
                this.broadcastPacket(3);
            }
        }

        @Override
        public void bossBarProgressChanged(@NotNull net.kyori.adventure.bossbar.BossBar bossBar, float f, float f2) {
            this.bar.setHealth(f2);
            this.broadcastPacket(2);
        }

        @Override
        public void bossBarColorChanged(@NotNull net.kyori.adventure.bossbar.BossBar bossBar,  @NotNull BossBar.Color color,  @NotNull BossBar.Color color2) {
            this.bar.setColor(this.createColor(color2));
            this.broadcastPacket(4);
        }

        @Override
        public void bossBarOverlayChanged(@NotNull net.kyori.adventure.bossbar.BossBar bossBar,  @NotNull BossBar.Overlay overlay,  @NotNull BossBar.Overlay overlay2) {
            this.bar.setDivision(this.createOverlay(overlay2));
            this.broadcastPacket(4);
        }

        @Override
        public void bossBarFlagsChanged(@NotNull net.kyori.adventure.bossbar.BossBar bossBar, @NotNull Set<BossBar.Flag> set, @NotNull Set<BossBar.Flag> set2) {
            this.bar.setFlags(this.createFlag(this.bar.getFlags(), set, set2));
            this.broadcastPacket(5);
        }

        @Override
        public void addViewer(@NotNull ProxiedPlayer proxiedPlayer) {
            this.viewers.add(proxiedPlayer);
            this.sendPacket(0, proxiedPlayer);
        }

        @Override
        public void removeViewer(@NotNull ProxiedPlayer proxiedPlayer) {
            this.viewers.remove(proxiedPlayer);
            this.sendPacket(1, proxiedPlayer);
        }

        @Override
        public boolean isEmpty() {
            return !this.initialized || this.viewers.isEmpty();
        }

        @Override
        public void close() {
            this.broadcastPacket(1);
            this.viewers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void broadcastPacket(int n) {
            if (this.isEmpty()) {
                return;
            }
            net.md_5.bungee.protocol.packet.BossBar bossBar = this.bar;
            synchronized (bossBar) {
                this.bar.setAction(n);
                for (ProxiedPlayer proxiedPlayer : this.viewers) {
                    proxiedPlayer.unsafe().sendPacket((DefinedPacket)this.bar);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPacket(int n, ProxiedPlayer ... proxiedPlayerArray) {
            net.md_5.bungee.protocol.packet.BossBar bossBar = this.bar;
            synchronized (bossBar) {
                int n2 = this.bar.getAction();
                this.bar.setAction(n);
                for (ProxiedPlayer proxiedPlayer : proxiedPlayerArray) {
                    proxiedPlayer.unsafe().sendPacket((DefinedPacket)this.bar);
                }
                this.bar.setAction(n2);
            }
        }

        static class Builder
        extends BungeeFacet<ProxiedPlayer>
        implements Facet.BossBar.Builder<ProxiedPlayer, BossBar> {
            protected Builder() {
                super(ProxiedPlayer.class);
            }

            @Override
            public boolean isApplicable(@NotNull ProxiedPlayer proxiedPlayer) {
                return super.isApplicable(proxiedPlayer) && proxiedPlayer.getPendingConnection().getVersion() >= 356;
            }

            @Override
            public @NotNull BossBar createBossBar(@NotNull Collection<ProxiedPlayer> collection) {
                return new BossBar(collection);
            }
        }
    }

    static class Title
    extends Message
    implements Facet.Title<ProxiedPlayer, BaseComponent[], net.md_5.bungee.api.Title, net.md_5.bungee.api.Title> {
        private static final net.md_5.bungee.api.Title CLEAR = ProxyServer.getInstance().createTitle().clear();
        private static final net.md_5.bungee.api.Title RESET = ProxyServer.getInstance().createTitle().reset();

        Title() {
        }

        @Override
        public @NotNull net.md_5.bungee.api.Title createTitleCollection() {
            return ProxyServer.getInstance().createTitle();
        }

        @Override
        public void contributeTitle(@NotNull net.md_5.bungee.api.Title title, BaseComponent @NotNull [] baseComponentArray) {
            title.title(baseComponentArray);
        }

        @Override
        public void contributeSubtitle(@NotNull net.md_5.bungee.api.Title title, BaseComponent @NotNull [] baseComponentArray) {
            title.subTitle(baseComponentArray);
        }

        @Override
        public void contributeTimes(@NotNull net.md_5.bungee.api.Title title, int n, int n2, int n3) {
            if (n > -1) {
                title.fadeIn(n);
            }
            if (n2 > -1) {
                title.stay(n2);
            }
            if (n3 > -1) {
                title.fadeOut(n3);
            }
        }

        @Override
        @Nullable
        public net.md_5.bungee.api.Title completeTitle(@NotNull net.md_5.bungee.api.Title title) {
            return title;
        }

        @Override
        public void showTitle(@NotNull ProxiedPlayer proxiedPlayer, @NotNull net.md_5.bungee.api.Title title) {
            proxiedPlayer.sendTitle(title);
        }

        @Override
        public void clearTitle(@NotNull ProxiedPlayer proxiedPlayer) {
            proxiedPlayer.sendTitle(CLEAR);
        }

        @Override
        public void resetTitle(@NotNull ProxiedPlayer proxiedPlayer) {
            proxiedPlayer.sendTitle(RESET);
        }
    }

    static class ActionBar
    extends Message
    implements Facet.ActionBar<ProxiedPlayer, BaseComponent[]> {
        ActionBar() {
        }

        @Override
        public void sendMessage(@NotNull ProxiedPlayer proxiedPlayer, BaseComponent @NotNull [] baseComponentArray) {
            proxiedPlayer.sendMessage(ChatMessageType.ACTION_BAR, baseComponentArray);
        }
    }

    static class ChatPlayer
    extends Message
    implements Facet.Chat<ProxiedPlayer, BaseComponent[]> {
        ChatPlayer() {
        }

        @Nullable
        public ChatMessageType createType(@NotNull MessageType messageType) {
            if (messageType == MessageType.CHAT) {
                return ChatMessageType.CHAT;
            }
            if (messageType == MessageType.SYSTEM) {
                return ChatMessageType.SYSTEM;
            }
            Knob.logUnsupported(this, (Object)messageType);
            return null;
        }

        @Override
        public void sendMessage(@NotNull ProxiedPlayer proxiedPlayer, @NotNull Identity identity, BaseComponent @NotNull [] baseComponentArray, @NotNull MessageType messageType) {
            ChatMessageType chatMessageType = this.createType(messageType);
            if (chatMessageType != null) {
                proxiedPlayer.sendMessage(chatMessageType, baseComponentArray);
            }
        }
    }

    static class ChatPlayerSenderId
    extends ChatPlayer
    implements Facet.Chat<ProxiedPlayer, BaseComponent[]> {
        private static final boolean SUPPORTED;

        ChatPlayerSenderId() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public void sendMessage(@NotNull ProxiedPlayer proxiedPlayer, @NotNull Identity identity, BaseComponent @NotNull [] baseComponentArray, @NotNull MessageType messageType) {
            if (messageType == MessageType.CHAT) {
                proxiedPlayer.sendMessage(identity.uuid(), baseComponentArray);
            } else {
                super.sendMessage(proxiedPlayer, identity, baseComponentArray, messageType);
            }
        }

        static {
            boolean bl;
            try {
                ProxiedPlayer.class.getMethod("sendMessage", UUID.class, BaseComponent.class);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = false;
            }
            SUPPORTED = bl;
        }
    }

    static class Message
    extends BungeeFacet<ProxiedPlayer>
    implements Facet.Message<ProxiedPlayer, BaseComponent[]> {
        protected Message() {
            super(ProxiedPlayer.class);
        }

        @Override
        public BaseComponent @NotNull [] createMessage(@NotNull ProxiedPlayer proxiedPlayer, @NotNull Component component) {
            if (proxiedPlayer.getPendingConnection().getVersion() >= 713) {
                return MODERN.serialize(component);
            }
            return LEGACY.serialize(component);
        }
    }

    static class ChatConsole
    extends BungeeFacet<CommandSender>
    implements Facet.Chat<CommandSender, BaseComponent[]> {
        protected ChatConsole() {
            super(CommandSender.class);
        }

        @Override
        public boolean isApplicable(@NotNull CommandSender commandSender) {
            return super.isApplicable(commandSender) && !(commandSender instanceof Connection);
        }

        @Override
        public BaseComponent @NotNull [] createMessage(@NotNull CommandSender commandSender, @NotNull Component component) {
            return LEGACY.serialize(component);
        }

        @Override
        public void sendMessage(@NotNull CommandSender commandSender, @NotNull Identity identity, BaseComponent @NotNull [] baseComponentArray, @NotNull MessageType messageType) {
            commandSender.sendMessage(baseComponentArray);
        }
    }
}

