/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.manage.Kick;
import us.ajg0702.queue.commands.commands.manage.KickAll;
import us.ajg0702.queue.commands.commands.manage.Pause;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.commands.commands.manage.QueueList;
import us.ajg0702.queue.commands.commands.manage.Reload;
import us.ajg0702.queue.commands.commands.manage.Send;
import us.ajg0702.queue.commands.commands.manage.Update;
import us.ajg0702.queue.commands.commands.manage.debug.ISP;
import us.ajg0702.queue.commands.commands.manage.debug.PermissionList;
import us.ajg0702.queue.commands.commands.manage.debug.Protocol;
import us.ajg0702.queue.commands.commands.manage.debug.Tasks;
import us.ajg0702.queue.commands.commands.manage.debug.Version;
import us.ajg0702.queue.commands.commands.manage.debug.Whitelist;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class ManageCommand
extends BaseCommand {
    final QueueMain main;
    final List<ISubCommand> subCommands = new ArrayList<ISubCommand>();

    public ManageCommand(QueueMain queueMain) {
        this.main = queueMain;
        this.addSubCommand(new Protocol(queueMain));
        this.addSubCommand(new ISP(queueMain));
        this.addSubCommand(new PermissionList(queueMain));
        this.addSubCommand(new Tasks(queueMain));
        this.addSubCommand(new Version(queueMain));
        this.addSubCommand(new Whitelist(queueMain));
        this.addSubCommand(new Reload(queueMain));
        this.addSubCommand(new Pause(queueMain));
        this.addSubCommand(new QueueList(queueMain));
        this.addSubCommand(new Send(queueMain));
        this.addSubCommand(new Update(queueMain));
        this.addSubCommand(new Kick(queueMain));
        this.addSubCommand(new KickAll(queueMain));
        this.addSubCommand(new PauseQueueServer(queueMain));
    }

    @Override
    public String getName() {
        return "ajqueue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"ajq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.copyOf(this.subCommands);
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void addSubCommand(ISubCommand iSubCommand) {
        this.subCommands.add(iSubCommand);
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length > 0) {
            for (ISubCommand iSubCommand : this.subCommands) {
                if (!stringArray[0].equalsIgnoreCase(iSubCommand.getName()) && !iSubCommand.getAliases().contains((Object)stringArray[0].toLowerCase(Locale.ROOT))) continue;
                iSubCommand.execute(iCommandSender, Arrays.copyOfRange(stringArray, 1, stringArray.length));
                return;
            }
        }
        iCommandSender.sendMessage(Component.text("/ajQueue <reload|list|send|pause>"));
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length > 1) {
            for (ISubCommand iSubCommand : this.subCommands) {
                if (!stringArray[0].equalsIgnoreCase(iSubCommand.getName()) && !iSubCommand.getAliases().contains((Object)stringArray[0].toLowerCase(Locale.ROOT)) || !iCommandSender.hasPermission(iSubCommand.getPermission())) continue;
                return iSubCommand.autoComplete(iCommandSender, Arrays.copyOfRange(stringArray, 1, stringArray.length));
            }
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ISubCommand iSubCommand : this.subCommands) {
            if (!iSubCommand.showInTabComplete() || !iCommandSender.hasPermission(iSubCommand.getPermission())) continue;
            arrayList.add(iSubCommand.getName());
            arrayList.addAll((Collection<String>)iSubCommand.getAliases());
        }
        return arrayList;
    }
}

