/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Pause
extends SubCommand {
    final QueueMain main;

    public Pause(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "pause";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.pause";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (stringArray.length < 1) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.pause.more-args", new String[0]));
            return;
        }
        QueueServer queueServer = this.main.getQueueManager().findServer(stringArray[0]);
        if (queueServer == null && !stringArray[0].equalsIgnoreCase("all")) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.pause.no-server", "SERVER:" + stringArray[0]));
            return;
        }
        List<QueueServer> list = queueServer == null && stringArray[0].equalsIgnoreCase("all") ? this.main.getQueueManager().getServers() : Collections.singletonList(queueServer);
        for (QueueServer queueServer2 : list) {
            if (stringArray.length == 1) {
                queueServer2.setPaused(!queueServer2.isPaused());
            } else {
                queueServer2.setPaused(stringArray[1].equalsIgnoreCase("on") || stringArray[1].equalsIgnoreCase("true"));
            }
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.pause.success", "SERVER:" + queueServer2.getName(), "PAUSED:" + this.getMessages().getString("commands.pause.paused." + queueServer2.isPaused(), new String[0])));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            ArrayList<String> arrayList = new ArrayList<String>((Collection<String>)this.main.getQueueManager().getServerNames());
            arrayList.add("all");
            return arrayList;
        }
        if (stringArray.length == 2) {
            return Arrays.asList("on", "off", "true", "false");
        }
        return new ArrayList<String>();
    }
}

