/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.queue;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class QueueCommand
extends BaseCommand {
    public static Map<AdaptedPlayer, Long> cooldowns = new ConcurrentHashMap<AdaptedPlayer, Long>();
    private final QueueMain main;

    public QueueCommand(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "queue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("move", "joinqueue", "joinq"));
        if (this.main.getConfig().getBoolean("enable-server-command")) {
            arrayList.add("server");
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.builder().build();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (!iCommandSender.isPlayer()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        AdaptedPlayer adaptedPlayer = this.main.getPlatformMethods().senderToPlayer(iCommandSender);
        double d = this.main.getConfig().getDouble("queue-command-cooldown");
        if (d > 0.0) {
            long l = cooldowns.getOrDefault(adaptedPlayer, 0L);
            if ((double)(System.currentTimeMillis() - l) < d * 1000.0) {
                iCommandSender.sendMessage(this.main.getMessages().getComponent("errors.too-fast-queue", new String[0]));
                return;
            }
            cooldowns.put(adaptedPlayer, System.currentTimeMillis());
        }
        if (stringArray.length > 0) {
            if (this.main.getConfig().getBoolean("require-permission") && !adaptedPlayer.hasPermission("ajqueue.queue." + stringArray[0])) {
                iCommandSender.sendMessage(this.getMessages().getComponent("noperm", new String[0]));
                return;
            }
            if (this.main.getConfig().getBoolean("joinfrom-server-permission") && !adaptedPlayer.hasPermission("ajqueue.joinfrom." + adaptedPlayer.getServerName())) {
                adaptedPlayer.sendMessage(this.getMessages().getComponent("errors.deny-joining-from-server", new String[0]));
                return;
            }
            this.main.getQueueManager().addToQueue(adaptedPlayer, stringArray[0]);
        } else {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.joinqueue.usage", new String[0]));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.main.getConfig().getBoolean("tab-complete-queues")) {
            return new ArrayList<String>();
        }
        if (stringArray.length == 1) {
            List<String> list = this.filterCompletion((List<String>)this.main.getQueueManager().getServerNames(), stringArray[0]);
            if (this.main.getConfig().getBoolean("require-permission")) {
                list.removeIf(string -> !iCommandSender.hasPermission("ajqueue.queue." + string));
            }
            return list;
        }
        return new ArrayList<String>();
    }
}

