/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.EventHandler;
import us.ajg0702.queue.api.events.SuccessfulSendEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.communication.CommunicationManager;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.utils.Debug;

public class EventHandlerImpl
implements EventHandler {
    final QueueMain main;
    CommunicationManager communicationManager;

    public EventHandlerImpl(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public void handleMessage(AdaptedPlayer adaptedPlayer, byte[] byArray) {
        if (!adaptedPlayer.isConnected()) {
            return;
        }
        if (this.communicationManager == null) {
            this.communicationManager = new CommunicationManager(this.main);
        }
        try {
            this.communicationManager.handle(adaptedPlayer, byArray);
        }
        catch (IOException iOException) {
            this.main.getLogger().warning("An error occurred while reading data from spigot side:", iOException);
        }
    }

    @Override
    public void onPlayerJoin(AdaptedPlayer adaptedPlayer) {
        if (adaptedPlayer.hasPermission("ajqueue.manage.update")) {
            this.main.getTaskManager().runLater(() -> {
                if (this.main.getUpdater().isUpdateAvailable() && !this.main.getUpdater().isAlreadyDownloaded()) {
                    adaptedPlayer.sendMessage(this.main.getMessages().getComponent("updater.update-available", new String[0]));
                }
            }, 2L, TimeUnit.SECONDS);
        }
        ImmutableList<QueuePlayer> immutableList = this.main.getQueueManager().findPlayerInQueues(adaptedPlayer);
        for (QueuePlayer queuePlayer : immutableList) {
            queuePlayer.setPlayer(adaptedPlayer);
        }
        if (immutableList.size() > 0) {
            this.main.getQueueManager().sendMessage(this.main.getQueueManager().getSingleServer(adaptedPlayer).findPlayer(adaptedPlayer));
        }
    }

    @Override
    public void onPlayerLeave(AdaptedPlayer adaptedPlayer) {
        ImmutableList<QueuePlayer> immutableList = this.main.getQueueManager().findPlayerInQueues(adaptedPlayer);
        for (QueuePlayer queuePlayer : immutableList) {
            ((QueuePlayerImpl)queuePlayer).setLeaveTime(System.currentTimeMillis());
            List<String> list = this.main.getConfig().getStringList("queue-servers");
            for (String string : list) {
                if (!string.contains(":")) continue;
                String[] stringArray = string.split(":");
                String string2 = stringArray[0];
                if (!queuePlayer.getQueueServer().getServerNames().contains((Object)string2)) continue;
                queuePlayer.getQueueServer().removePlayer(queuePlayer);
            }
        }
        this.main.getQueueManager().clear(adaptedPlayer);
        QueueCommand.cooldowns.remove(adaptedPlayer);
    }

    @Override
    public void onPlayerJoinServer(AdaptedPlayer adaptedPlayer) {
        Object object;
        ImmutableList<QueuePlayer> immutableList = this.main.getQueueManager().findPlayerInQueues(adaptedPlayer);
        for (Object object2 : immutableList) {
            object = object2.getQueueServer();
            int n = object2.getPosition();
            if ((n > 1 || !object.getServerNames().contains((Object)adaptedPlayer.getServerName())) && !this.main.getConfig().getBoolean("remove-player-on-server-switch")) continue;
            object.removePlayer(adaptedPlayer);
            object.setLastSentTime(System.currentTimeMillis());
            this.main.getQueueManager().getSendingAttempts().remove(object2);
            this.main.getTaskManager().runNow(() -> this.lambda$onPlayerJoinServer$1((QueuePlayer)object2, adaptedPlayer));
        }
        if (this.main.getConfig().getBoolean("include-server-switch-in-cooldown")) {
            QueueCommand.cooldowns.put(adaptedPlayer, System.currentTimeMillis());
        }
        if (!PauseQueueServer.pausedPlayers.contains(adaptedPlayer)) {
            Object object2;
            Object object3 = adaptedPlayer.getServerName();
            object2 = this.main.getConfig().getStringList("queue-servers");
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!string.contains(":")) continue;
                String[] stringArray = string.split(":");
                String string2 = stringArray[0];
                QueueServer queueServer = this.main.getQueueManager().findServer(stringArray[1]);
                if (!string2.equalsIgnoreCase((String)object3) || queueServer == null) continue;
                this.main.getQueueManager().addToQueue(adaptedPlayer, queueServer);
            }
        }
    }

    @Override
    public void onServerKick(AdaptedPlayer adaptedPlayer, @NotNull AdaptedServer adaptedServer, Component component, boolean bl) {
        Object object;
        Object object2;
        ImmutableList<QueueServer> immutableList;
        if (!adaptedPlayer.isConnected()) {
            return;
        }
        String string = PlainTextComponentSerializer.plainText().serialize(component);
        Debug.info(adaptedPlayer.getName() + " kicked! Moving: " + bl + " from: " + adaptedServer.getName() + " plainReason: " + string);
        if (!bl && this.main.getConfig().getBoolean("send-fail-debug")) {
            this.main.getLogger().warning("Failed to send " + adaptedPlayer.getName() + " to " + adaptedServer.getName() + ". Kicked with reason: " + string);
        }
        if (!(immutableList = this.main.getQueueManager().getPlayerQueues(adaptedPlayer)).contains((Object)this.main.getQueueManager().findServer(adaptedServer.getName())) && this.main.getConfig().getBoolean("auto-add-to-queue-on-kick")) {
            List<String> list = this.main.getConfig().getStringList("auto-add-kick-reasons");
            boolean bl2 = false;
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!string.toLowerCase().contains(((String)object).toLowerCase())) continue;
                bl2 = true;
                break;
            }
            if (bl2 || list.isEmpty()) {
                this.main.getTaskManager().runLater(() -> {
                    if (!adaptedPlayer.isConnected()) {
                        return;
                    }
                    String string = adaptedServer.getName();
                    adaptedPlayer.sendMessage(this.main.getMessages().getComponent("auto-queued", "SERVER:" + string));
                    this.main.getQueueManager().addToQueue(adaptedPlayer, string);
                }, (long)(this.main.getConfig().getDouble("auto-add-to-queue-on-kick-delay") * 1000.0), TimeUnit.MILLISECONDS);
                return;
            }
        }
        block1: for (QueueServer queueServer : immutableList) {
            Object object3;
            if (!queueServer.getServerNames().contains((Object)adaptedServer.getName()) || (object2 = queueServer.findPlayer(adaptedPlayer)).getPosition() != 1) continue;
            object = this.main.getConfig().getStringList("kick-reasons");
            boolean bl3 = this.main.getConfig().getBoolean("kick-kicked-players");
            if (bl3) {
                Debug.info("Initially kicking player");
                object3 = this.main.getConfig().getStringList("queue-servers");
                boolean bl4 = false;
                Iterator<String> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    if (!string2.contains(":")) continue;
                    String[] stringArray = string2.split(":");
                    String string3 = stringArray[0];
                    QueueServer queueServer2 = this.main.getQueueManager().findServer(stringArray[1]);
                    if (queueServer2 == null) continue;
                    Debug.info("fromName equals: " + string3.equalsIgnoreCase(adaptedPlayer.getServerName()) + " (" + string3 + " = " + adaptedPlayer.getServerName() + ") toServer equals: " + queueServer2.equals(queueServer));
                    if (!string3.equalsIgnoreCase(adaptedPlayer.getServerName()) || !queueServer2.equals(queueServer)) continue;
                    bl4 = true;
                }
                bl3 = bl4;
            }
            Debug.info("Kick player: " + bl3);
            object3 = object.iterator();
            while (object3.hasNext()) {
                String string4 = (String)object3.next();
                if (!string.toLowerCase().contains(string4.toLowerCase())) continue;
                queueServer.removePlayer((QueuePlayer)object2);
                if (!bl3) continue block1;
                adaptedPlayer.kick(component);
                continue block1;
            }
        }
    }

    private /* synthetic */ void lambda$onPlayerJoinServer$1(QueuePlayer queuePlayer, AdaptedPlayer adaptedPlayer) {
        this.main.call(new SuccessfulSendEvent(queuePlayer, adaptedPlayer.getCurrentServer()));
    }
}

