/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import us.ajg0702.queue.api.QueueManager;
import us.ajg0702.queue.api.events.PreQueueEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.premium.Logic;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.queues.QueueServerImpl;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.common.TimeUtils;

public class QueueManagerImpl
implements QueueManager {
    private CopyOnWriteArrayList<QueueServer> servers = new CopyOnWriteArrayList();
    private final QueueMain main;
    private final Messages msgs;
    protected final Map<AdaptedPlayer, Long> pausedAntiSpam = new ConcurrentHashMap<AdaptedPlayer, Long>();
    final ConcurrentHashMap<AdaptedPlayer, Long> sendingNowAntiSpam = new ConcurrentHashMap();
    final Map<QueuePlayer, Integer> sendingAttempts = new WeakHashMap<QueuePlayer, Integer>();

    public QueueManagerImpl(QueueMain queueMain) {
        this.main = queueMain;
        this.msgs = queueMain.getMessages();
        int n = queueMain.getConfig().getBoolean("wait-to-load-servers") ? queueMain.getConfig().getInt("wait-to-load-servers-delay") : 0;
        queueMain.getTaskManager().runLater(this::reloadServers, n, TimeUnit.MILLISECONDS);
    }

    public List<QueueServer> buildServers() {
        Object object;
        Object object2;
        String[] stringArray;
        Object object32;
        Object object4;
        ArrayList<QueueServer> arrayList = new ArrayList<QueueServer>();
        List<? extends AdaptedServer> list = this.main.getPlatformMethods().getServers();
        for (AdaptedServer object52 : list) {
            object4 = this.findServer(object52.getName());
            Object object5 = object32 = object4 == null ? new ImmutableList<QueuePlayer>() : object4.getQueue();
            if (object32.size() > 0) {
                this.main.getLogger().info("Adding " + object32.size() + " players back to the queue for " + object52.getName());
            }
            stringArray = new QueueServerImpl(object52.getName(), this.main, object52, (List<QueuePlayer>)object32);
            if (object4 != null) {
                stringArray.setPaused(object4.isPaused());
                stringArray.setLastSentTime(object4.getLastSentTime());
            }
            arrayList.add((QueueServer)stringArray);
        }
        List<String> list2 = this.main.getConfig().getStringList("server-groups");
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ImmutableList<QueuePlayer> immutableList;
            object4 = (String)iterator.next();
            if (((String)object4).isEmpty()) {
                this.main.getLogger().warning("Empty group string! If you dont want server groups, set server-groups like this: server-groups: []");
                continue;
            }
            if (!((String)object4).contains(":")) {
                this.main.getLogger().warning("Incorrect formatting! Each server group needs to have a name and a list of servers seperated by a colon (:).");
                continue;
            }
            object32 = ((String)object4).split(":")[0];
            stringArray = ((String)object4).split(":")[1].split(",");
            if (this.findServer((String)object32, arrayList) != null) {
                this.main.getLogger().warning("The name of a group ('" + (String)object32 + "') cannot be the same as the name of a server!");
                continue;
            }
            object2 = new ArrayList();
            for (String string : stringArray) {
                QueueServer queueServer = this.findServer(string, arrayList);
                if (queueServer == null) {
                    this.main.getLogger().warning("Could not find server named '" + string + "' in servergroup '" + (String)object32 + "'!");
                    continue;
                }
                if (queueServer.isGroup()) continue;
                object2.add(queueServer.getServers().get(0));
            }
            if (object2.size() == 0) {
                this.main.getLogger().warning("Server group '" + (String)object32 + "' has no servers! Ignoring it.");
                continue;
            }
            object = this.main.getQueueManager().findServer((String)object32);
            ImmutableList<QueuePlayer> immutableList2 = immutableList = object == null ? new ImmutableList<QueuePlayer>() : object.getQueue();
            if (immutableList.size() > 0) {
                this.main.getLogger().info("Adding " + immutableList.size() + " players back to the queue for " + (String)object32);
            }
            arrayList.add(new QueueServerImpl((String)object32, this.main, (List<AdaptedServer>)object2, (List<QueuePlayer>)immutableList));
        }
        List<String> list3 = this.main.getConfig().getStringList("supported-protocols");
        for (Object object32 : list3) {
            stringArray = ((String)object32).split(":");
            if (stringArray.length < 2) {
                this.main.getLogger().warn("Invalid supported protocols entry! Must have a colon to seperate the server(s) and the protocols");
                continue;
            }
            object2 = stringArray[0];
            object = stringArray[1];
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (String string : ((String)object).split(",")) {
                try {
                    arrayList2.add(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.main.getLogger().info("The protocol " + string + " is not a valid number!");
                }
            }
            for (String string : ((String)object2).split(",")) {
                boolean bl = false;
                for (QueueServer queueServer : arrayList) {
                    if (!string.equalsIgnoreCase(queueServer.getName())) continue;
                    queueServer.setSupportedProtocols(arrayList2);
                    bl = true;
                    Debug.info("Applied " + arrayList2 + " to " + queueServer.getName() + "(" + string + ")");
                    break;
                }
                if (bl) continue;
                Debug.info("Found no server named " + string);
            }
        }
        return arrayList;
    }

    @Override
    public boolean addToQueue(AdaptedPlayer adaptedPlayer, QueueServer queueServer) {
        boolean bl;
        int n;
        int n2;
        QueuePlayer queuePlayer;
        Object object2;
        if (adaptedPlayer == null || queueServer == null) {
            Debug.info("addToQueue method called, but something is null");
            return false;
        }
        if (!adaptedPlayer.isConnected()) {
            Debug.info("addToQueue method called, but player is not connected");
            return false;
        }
        if (adaptedPlayer.getServerName() == null) {
            this.main.getLogger().warning("Tried to queue " + adaptedPlayer.getName() + " when they aren't connected!");
            return false;
        }
        Debug.info("addToQueue method called for " + adaptedPlayer.getName() + " to " + queueServer.getName());
        int n3 = adaptedPlayer.getProtocolVersion();
        List<Integer> list = queueServer.getSupportedProtocols();
        if (!list.contains(n3) && list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n4 : list) {
                stringBuilder.append(this.main.getProtocolNameManager().getProtocolName(n4));
                if (list.indexOf(n4) == list.size() - 2) {
                    stringBuilder.append(this.msgs.getString("errors.wrong-version.or", new String[0]));
                    continue;
                }
                if (list.indexOf(n4) == list.size() - 1) continue;
                stringBuilder.append(this.msgs.getString("errors.wrong-version.comma", new String[0]));
            }
            adaptedPlayer.sendMessage(this.msgs.getComponent("errors.wrong-version.base", "VERSIONS:" + stringBuilder, "SERVER:" + queueServer.getAlias()));
            return false;
        }
        boolean bl2 = this.main.getConfig().getBoolean("enable-bypasspaused-permission");
        if (queueServer.isPaused() && this.main.getConfig().getBoolean("prevent-joining-paused") && (!bl2 || !adaptedPlayer.hasPermission("ajqueue.bypasspaused"))) {
            adaptedPlayer.sendMessage(this.msgs.getComponent("errors.cant-join-paused", "SERVER:" + queueServer.getAlias()));
            return false;
        }
        ArrayList<AdaptedServer> arrayList = new ArrayList<AdaptedServer>((Collection<AdaptedServer>)queueServer.getServers());
        arrayList.removeIf(adaptedServer -> !adaptedServer.getName().equals(adaptedPlayer.getServerName()));
        if (arrayList.size() > 0) {
            adaptedPlayer.sendMessage(this.msgs.getComponent("errors.already-connected", "SERVER:" + queueServer.getAlias()));
            return false;
        }
        ImmutableList<QueueServer> immutableList = this.getPlayerQueues(adaptedPlayer);
        if (immutableList.size() > 0) {
            if (immutableList.contains((Object)queueServer)) {
                adaptedPlayer.sendMessage(this.msgs.getComponent("errors.already-queued", new String[0]));
                return false;
            }
            if (!this.main.getConfig().getBoolean("allow-multiple-queues")) {
                adaptedPlayer.sendMessage(this.msgs.getComponent("status.left-last-queue", "SERVER:" + queueServer.getAlias()));
                for (Object object2 : immutableList) {
                    object2.removePlayer(adaptedPlayer);
                }
            }
        }
        PreQueueEvent preQueueEvent = new PreQueueEvent(adaptedPlayer, queueServer);
        this.main.call(preQueueEvent);
        if (preQueueEvent.isCancelled()) {
            return false;
        }
        object2 = queueServer.getQueue();
        AdaptedServer adaptedServer2 = queueServer.getIdealServer(adaptedPlayer);
        if (this.main.isPremium()) {
            queuePlayer = this.main.getLogic().priorityLogic(queueServer, adaptedPlayer, adaptedServer2);
        } else {
            n2 = adaptedPlayer.hasPermission("ajqueue.priority") || adaptedPlayer.hasPermission("ajqueue.serverpriority." + queueServer.getName()) ? 1 : 0;
            n2 = Math.max(n2, Logic.getUnJoinablePriorities(queueServer, adaptedServer2, adaptedPlayer) > 0 ? 1 : 0);
            n = adaptedPlayer.hasPermission("ajqueue.stayqueued") ? 60 : 0;
            queuePlayer = new QueuePlayerImpl(adaptedPlayer, queueServer, n2, n);
            if (n2 == 1 && queueServer.getQueue().size() > 0) {
                bl = false;
                UnmodifiableIterator unmodifiableIterator = object2.iterator();
                while (unmodifiableIterator.hasNext()) {
                    QueuePlayer queuePlayer2 = (QueuePlayer)unmodifiableIterator.next();
                    if (!queuePlayer2.hasPriority()) {
                        queueServer.addPlayer(queuePlayer, bl ? 1 : 0);
                        break;
                    }
                    bl += 1;
                }
            }
            if (!object2.contains((Object)queuePlayer)) {
                queueServer.addPlayer(queuePlayer);
            }
        }
        object2 = queueServer.getQueue();
        n2 = queuePlayer.getPosition();
        n = object2.size();
        bl = queueServer.isJoinable(adaptedPlayer);
        boolean bl3 = object2.size() <= 1 && queueServer.isJoinable(adaptedPlayer);
        boolean bl4 = !this.main.getConfig().getBoolean("check-last-player-sent-time") || (double)queueServer.getLastSentTime() > Math.floor(this.main.getTimeBetweenPlayers() * 1000.0);
        boolean bl5 = this.main.getConfig().getStringList("send-instantly").contains(queueServer.getName());
        boolean bl6 = this.main.getLogic().hasAnyBypass(adaptedPlayer, queueServer.getName());
        boolean bl7 = bl5 || bl && bl3 && bl4 || bl6;
        Debug.info("should send instantly (" + bl7 + "): " + bl5 + " || (" + bl + " && (" + bl3 + " && " + bl4 + ") && " + !bl6 + ")");
        if (bl7) {
            if (!bl6) {
                this.sendPlayers(queueServer);
            }
            if (!this.msgs.isEmpty("status.now-in-empty-queue")) {
                adaptedPlayer.sendMessage(this.msgs.getComponent("status.now-in-empty-queue", "POS:" + n2, "LEN:" + n, "SERVER:" + queueServer.getAlias()));
            }
        } else {
            adaptedPlayer.sendMessage(this.msgs.getComponent("status.now-in-queue", "POS:" + n2, "LEN:" + n, "SERVER:" + queueServer.getAlias(), "SERVERNAME:" + queueServer.getName()));
            if (this.main.getConfig().getBoolean("enable-priority-messages")) {
                for (String string : this.main.getConfig().getStringList("priority-messages")) {
                    String[] stringArray = string.split(":");
                    if (stringArray.length != 2) continue;
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    if ((!string2.equals("*") || queuePlayer.getPriority() <= 0) && !string2.equals(queuePlayer.getPriority() + "")) continue;
                    adaptedPlayer.sendMessage(this.main.getMessages().toComponent(string3.replaceAll("\\{PRIORITY}", queuePlayer.getPriority() + "")));
                }
            }
        }
        if (!queueServer.isJoinable(adaptedPlayer)) {
            this.sendMessage(queuePlayer);
        }
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, "position", n2 + "");
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, "positionof", n + "");
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, "queuename", queueServer.getAlias());
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, "inqueue", "true");
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, "inqueueevent", "true");
        return true;
    }

    @Override
    public boolean addToQueue(AdaptedPlayer adaptedPlayer, String string) {
        QueueServer queueServer = this.findServer(string);
        if (queueServer == null) {
            adaptedPlayer.sendMessage(this.msgs.getComponent("errors.server-not-exist", "SERVER:" + string));
            return false;
        }
        return this.addToQueue(adaptedPlayer, queueServer);
    }

    @Override
    public ImmutableList<QueueServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    @Override
    public ImmutableList<String> getServerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QueueServer queueServer : this.servers) {
            arrayList.add(queueServer.getName());
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public QueueServer getSingleServer(AdaptedPlayer adaptedPlayer) {
        ImmutableList<QueuePlayer> immutableList = this.findPlayerInQueues(adaptedPlayer);
        if (immutableList.size() <= 0) {
            return null;
        }
        QueueServer queueServer = ((QueuePlayer)immutableList.get(0)).getQueueServer();
        if (this.main.getConfig().getString("multi-server-queue-pick").equalsIgnoreCase("last")) {
            queueServer = ((QueuePlayer)immutableList.get(immutableList.size() - 1)).getQueueServer();
        }
        return queueServer;
    }

    @Override
    public String getQueuedName(AdaptedPlayer adaptedPlayer) {
        QueueServer queueServer = this.getSingleServer(adaptedPlayer);
        if (queueServer == null) {
            return this.main.getMessages().getString("placeholders.queued.none", new String[0]);
        }
        return queueServer.getName();
    }

    @Override
    public void reloadServers() {
        if (this.main.getConfig() == null) {
            this.main.getLogger().severe("[MAN] Config is null");
        }
        this.servers = new CopyOnWriteArrayList<QueueServer>(this.buildServers());
    }

    @Override
    public void sendActionBars() {
        if (!this.main.getConfig().getBoolean("send-actionbar")) {
            return;
        }
        for (QueueServer queueServer : this.servers) {
            for (QueuePlayer queuePlayer : queueServer.getQueue()) {
                int n = queuePlayer.getPosition();
                if (n == 0) {
                    queueServer.removePlayer(queuePlayer);
                    continue;
                }
                AdaptedPlayer adaptedPlayer = queuePlayer.getPlayer();
                if (adaptedPlayer == null) continue;
                String string = queueServer.getStatusString(adaptedPlayer);
                QueueServer queueServer2 = this.getSingleServer(adaptedPlayer);
                if (queueServer2 == null || !queueServer2.equals(queueServer)) continue;
                if (!queueServer.isJoinable(adaptedPlayer)) {
                    adaptedPlayer.sendActionBar(this.msgs.getComponent("spigot.actionbar.offline", "POS:" + n, "LEN:" + queueServer.getQueue().size(), "SERVER:" + queueServer.getAlias(), "STATUS:" + string));
                    continue;
                }
                int n2 = (int)Math.round((double)n * this.main.getTimeBetweenPlayers());
                adaptedPlayer.sendActionBar(this.msgs.getComponent("spigot.actionbar.online", "POS:" + n, "LEN:" + queueServer.getQueue().size(), "SERVER:" + queueServer.getAlias(), "TIME:" + TimeUtils.timeString(n2, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0]))));
            }
        }
    }

    @Override
    public void sendTitles() {
        if (!this.main.getConfig().getBoolean("send-title")) {
            return;
        }
        for (QueueServer queueServer : this.servers) {
            for (QueuePlayer queuePlayer : queueServer.getQueue()) {
                QueueServer queueServer2;
                int n = queuePlayer.getPosition();
                if (n == 0) {
                    queueServer.removePlayer(queuePlayer);
                    continue;
                }
                AdaptedPlayer adaptedPlayer = queuePlayer.getPlayer();
                if (adaptedPlayer == null || (queueServer2 = this.getSingleServer(adaptedPlayer)) == null || !queueServer2.equals(queueServer)) continue;
                String string = Messages.color(this.main.getMessages().getRawString("placeholders.status." + queueServer.getStatus(adaptedPlayer), new String[0]));
                int n2 = (int)Math.round((double)n * this.main.getTimeBetweenPlayers());
                Component component = this.msgs.getComponent("title.title", "POS:" + n, "LEN:" + queueServer.getQueue().size(), "SERVER:" + queueServer.getAlias(), "STATUS:" + string, "TIME:" + TimeUtils.timeString(n2, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])));
                Component component2 = this.msgs.getComponent("title.subtitle", "POS:" + n, "LEN:" + queueServer.getQueue().size(), "SERVER:" + queueServer.getAlias(), "STATUS:" + string, "TIME:" + TimeUtils.timeString(n2, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])));
                Title title = Title.title(component, component2, Title.Times.of(Duration.ZERO, Duration.ofSeconds(2L), Duration.ZERO));
                adaptedPlayer.showTitle(title);
            }
        }
    }

    @Override
    public void sendQueueEvents() {
        Object object;
        if (this.main.getConfig().getBoolean("force-queue-server-target")) {
            List<String> list = this.main.getConfig().getStringList("queue-servers");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.contains(":")) continue;
                String[] stringArray = string.split(":");
                object = stringArray[0];
                String string2 = stringArray[1];
                AdaptedServer adaptedServer = this.main.getPlatformMethods().getServer((String)object);
                QueueServer queueServer = this.findServer(string2);
                if (adaptedServer == null || queueServer == null) continue;
                adaptedServer.getPlayers().forEach(adaptedPlayer -> {
                    if (PauseQueueServer.pausedPlayers.contains(adaptedPlayer)) {
                        long l = this.pausedAntiSpam.getOrDefault(adaptedPlayer, 0L);
                        if ((double)(System.currentTimeMillis() - l) > 60000.0) {
                            adaptedPlayer.sendMessage(this.main.getMessages().getComponent("commands.pausequeueserver.reminder", new String[0]));
                            this.pausedAntiSpam.put((AdaptedPlayer)adaptedPlayer, System.currentTimeMillis());
                        }
                        return;
                    }
                    if (!this.getPlayerQueues((AdaptedPlayer)adaptedPlayer).contains((Object)queueServer)) {
                        this.addToQueue((AdaptedPlayer)adaptedPlayer, queueServer);
                    }
                });
            }
        }
        for (QueueServer queueServer : this.servers) {
            for (String[] stringArray : queueServer.getQueue()) {
                object = stringArray.getPlayer();
                if (object == null || !object.isConnected() || object.getServerName() == null) continue;
                this.main.getPlatformMethods().sendPluginMessage((AdaptedPlayer)object, "inqueueevent", "true");
            }
        }
    }

    @Override
    public void sendMessages() {
        try {
            for (QueueServer queueServer : this.servers) {
                for (QueuePlayer queuePlayer : queueServer.getQueue()) {
                    this.sendMessage(queuePlayer);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void sendMessage(QueuePlayer queuePlayer) {
        AdaptedPlayer adaptedPlayer = queuePlayer.getPlayer();
        if (adaptedPlayer == null || !adaptedPlayer.isConnected()) {
            return;
        }
        QueueServer queueServer = queuePlayer.getQueueServer();
        int n = queuePlayer.getPosition();
        int n2 = queueServer.getQueue().size();
        if (!queueServer.isJoinable(adaptedPlayer)) {
            String string = queueServer.getStatusString(adaptedPlayer);
            if (this.msgs.getString("status.offline.base", new String[0]).isEmpty()) {
                return;
            }
            adaptedPlayer.sendMessage(this.msgs.getComponent("status.offline.base", "STATUS:" + string, "POS:" + n, "LEN:" + n2, "SERVER:" + queueServer.getAlias()));
        } else {
            if (this.msgs.getString("status.online.base", new String[0]).isEmpty()) {
                return;
            }
            int n3 = (int)Math.round((double)n * this.main.getTimeBetweenPlayers());
            adaptedPlayer.sendMessage(this.msgs.getComponent("status.online.base", "TIME:" + TimeUtils.timeString(n3, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])), "POS:" + n, "LEN:" + n2, "SERVER:" + queueServer.getAlias()));
        }
    }

    @Override
    public void updateServers() {
        ExecutorService executorService = this.main.getTaskManager().getServersUpdateExecutor();
        if (executorService instanceof ThreadPoolExecutor && this.main.getConfig().getBoolean("pinger-debug")) {
            this.main.getLogger().info("[pinger] Server update thread pool has " + ((ThreadPoolExecutor)executorService).getActiveCount() + " threads");
        }
        try {
            for (AdaptedServer adaptedServer : this.main.getPlatformMethods().getServers()) {
                executorService.submit(() -> adaptedServer.ping(this.main.getConfig().getBoolean("pinger-debug"), this.main.getLogger()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public QueueServer findServer(String string) {
        return this.findServer(string, this.servers);
    }

    public QueueServer findServer(String string, List<QueueServer> list) {
        for (QueueServer queueServer : list) {
            if (queueServer == null || !queueServer.getName().equalsIgnoreCase(string)) continue;
            return queueServer;
        }
        return null;
    }

    @Override
    public void sendPlayers() {
        this.sendPlayers(null);
    }

    @Override
    public void sendPlayers(QueueServer queueServer) {
        List<QueueServer> list = queueServer == null ? new ArrayList<QueueServer>(this.servers) : Collections.singletonList(queueServer);
        for (QueueServer queueServer2 : list) {
            int n;
            AdaptedServer adaptedServer;
            Object object2;
            for (Object object2 : queueServer2.getQueue()) {
                if (object2.getPlayer() != null || !this.main.getLogic().playerDisconnectedTooLong((QueuePlayer)object2)) continue;
                queueServer2.removePlayer((QueuePlayer)object2);
            }
            if (!queueServer2.isOnline() || queueServer2.getQueue().size() == 0) continue;
            Debug.info("should send when back online: " + !queueServer2.isGroup() + " && " + this.main.getConfig().getBoolean("send-all-when-back-online") + " && " + ((AdaptedServer)queueServer2.getServers().get(0)).justWentOnline());
            if (!queueServer2.isGroup() && this.main.getConfig().getBoolean("send-all-when-back-online") && ((AdaptedServer)queueServer2.getServers().get(0)).justWentOnline()) {
                for (Object object2 : queueServer2.getQueue()) {
                    AdaptedPlayer adaptedPlayer = object2.getPlayer();
                    if (adaptedPlayer == null) continue;
                    adaptedServer = queueServer2.getIdealServer(adaptedPlayer);
                    if (adaptedServer == null) {
                        this.main.getLogger().severe("Could not find ideal server for server '" + queueServer2.getName() + "'!");
                        continue;
                    }
                    if (adaptedServer.isFull() && !adaptedServer.canJoinFull(object2.getPlayer())) continue;
                    adaptedPlayer.sendMessage(this.msgs.getComponent("status.sending-now", "SERVER:" + queueServer2.getAlias()));
                    Debug.info("Calling player.connect for " + adaptedPlayer.getName() + "(send when back online)");
                    adaptedPlayer.connect(adaptedServer);
                }
                continue;
            }
            Object object3 = (QueuePlayer)queueServer2.getQueue().get(0);
            object2 = object3.getPlayer();
            int n2 = 0;
            while ((object2 == null || queueServer2.getServerNames().contains((Object)object2.getServerName())) && n2 < queueServer2.getQueue().size()) {
                if (object2 != null) {
                    queueServer2.removePlayer((QueuePlayer)object3);
                    if (queueServer2.getQueue().size() > n2) {
                        object3 = (QueuePlayer)queueServer2.getQueue().get(n2);
                        object2 = object3.getPlayer();
                        continue;
                    }
                    object2 = null;
                    break;
                }
                if (++n2 > queueServer2.getQueue().size() - 1) break;
                object3 = (QueuePlayer)queueServer2.getQueue().get(n2);
                object2 = object3.getPlayer();
            }
            if (object2 == null) continue;
            adaptedServer = queueServer2.getIdealServer((AdaptedPlayer)object2);
            if (adaptedServer == null) {
                this.main.getLogger().severe("Could not find ideal server for server/group '" + queueServer2.getName() + "'");
                continue;
            }
            if (adaptedServer.isWhitelisted() && !adaptedServer.getWhitelistedPlayers().contains(object2.getUniqueId()) || !queueServer2.canAccess((AdaptedPlayer)object2) || adaptedServer.isFull() && !adaptedServer.canJoinFull((AdaptedPlayer)object2) || (!this.main.getConfig().getBoolean("enable-bypasspaused-permission") ? queueServer2.isPaused() : queueServer2.isPaused() && !object2.hasPermission("ajqueue.bypasspaused"))) continue;
            int n3 = this.sendingAttempts.getOrDefault(object3, 0);
            if (n3 >= (n = this.main.getConfig().getInt("max-tries").intValue()) && n > 0) {
                queueServer2.removePlayer((QueuePlayer)object3);
                this.sendingAttempts.remove(object3);
                object2.sendMessage(this.msgs.getComponent("max-tries-reached", "SERVER:" + queueServer2.getAlias()));
                continue;
            }
            this.sendingAttempts.put((QueuePlayer)object3, ++n3);
            if (!this.sendingNowAntiSpam.containsKey(object2)) {
                this.sendingNowAntiSpam.put((AdaptedPlayer)object2, 0L);
            }
            if (System.currentTimeMillis() - this.sendingNowAntiSpam.get(object2) >= 5000L) {
                object2.sendMessage(this.msgs.getComponent("status.sending-now", "SERVER:" + queueServer2.getAlias()));
                if (this.main.getConfig().getBoolean("send-title")) {
                    object2.showTitle(Title.title(this.main.getMessages().getComponent("title.sending-now.title", "SERVER:" + queueServer2.getAlias()), this.main.getMessages().getComponent("title.sending-now.subtitle", "SERVER:" + queueServer2.getAlias()), Title.Times.of(Duration.ZERO, Duration.ofSeconds(2L), Duration.ZERO)));
                }
                this.sendingNowAntiSpam.put((AdaptedPlayer)object2, System.currentTimeMillis());
            }
            queueServer2.setLastSentTime(System.currentTimeMillis());
            Debug.info("calling nextPlayer.connect on " + object2.getName());
            object2.connect(adaptedServer);
            adaptedServer.addPlayer();
            Debug.info(adaptedServer.getName() + " player count is now set to " + adaptedServer.getPlayerCount());
        }
    }

    @Override
    public ImmutableList<QueuePlayer> findPlayerInQueues(AdaptedPlayer adaptedPlayer) {
        ArrayList<QueuePlayer> arrayList = new ArrayList<QueuePlayer>();
        for (QueueServer queueServer : this.servers) {
            QueuePlayer queuePlayer = queueServer.findPlayer(adaptedPlayer);
            if (queuePlayer == null) continue;
            arrayList.add(queuePlayer);
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public ImmutableList<QueuePlayer> findPlayerInQueuesByName(String string) {
        ArrayList<QueuePlayer> arrayList = new ArrayList<QueuePlayer>();
        for (QueueServer queueServer : this.servers) {
            QueuePlayer queuePlayer = queueServer.findPlayer(string);
            if (queuePlayer == null) continue;
            arrayList.add(queuePlayer);
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public ImmutableList<QueueServer> getPlayerQueues(AdaptedPlayer adaptedPlayer) {
        ArrayList<QueueServer> arrayList = new ArrayList<QueueServer>();
        for (QueueServer queueServer : this.servers) {
            QueuePlayer queuePlayer = queueServer.findPlayer(adaptedPlayer);
            if (queuePlayer == null) continue;
            arrayList.add(queueServer);
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public void clear(AdaptedPlayer adaptedPlayer) {
        for (AdaptedPlayer adaptedPlayer2 : this.sendingNowAntiSpam.keySet()) {
            if (!adaptedPlayer2.equals(adaptedPlayer)) continue;
            this.sendingNowAntiSpam.remove(adaptedPlayer2);
        }
    }

    @Override
    public Map<QueuePlayer, Integer> getSendingAttempts() {
        return this.sendingAttempts;
    }
}

