/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.players;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;

public class QueuePlayerImpl
implements QueuePlayer {
    private AdaptedPlayer player;
    private final QueueServer server;
    private final int highestPriority;
    private final UUID uuid;
    private final String name;
    private final int maxOfflineTime;
    public int lastPosition;
    private long leaveTime = 0L;

    public QueuePlayerImpl(UUID uUID, String string, QueueServer queueServer, int n, int n2) {
        this(null, string, uUID, queueServer, n, n2);
    }

    public QueuePlayerImpl(AdaptedPlayer adaptedPlayer, QueueServer queueServer, int n, int n2) {
        this(adaptedPlayer, adaptedPlayer.getName(), adaptedPlayer.getUniqueId(), queueServer, n, n2);
    }

    private QueuePlayerImpl(@Nullable AdaptedPlayer adaptedPlayer, String string, @NotNull UUID uUID, QueueServer queueServer, int n, int n2) {
        this.player = adaptedPlayer;
        this.server = queueServer;
        this.highestPriority = n;
        this.uuid = uUID;
        this.name = string;
        this.maxOfflineTime = n2;
        this.lastPosition = this.getPosition();
    }

    @Override
    public UUID getUniqueId() {
        if (this.uuid == null) {
            throw new IllegalStateException("Why is my UUID null??");
        }
        return this.uuid;
    }

    @Override
    public QueueServer getQueueServer() {
        return this.server;
    }

    @Override
    public int getPosition() {
        return this.getQueueServer().getQueue().indexOf((Object)this) + 1;
    }

    @Override
    @Nullable
    public AdaptedPlayer getPlayer() {
        if (this.player != null && !this.player.isConnected()) {
            this.player = null;
        }
        return this.player;
    }

    @Override
    public void setPlayer(AdaptedPlayer adaptedPlayer) {
        if (adaptedPlayer != null && !adaptedPlayer.getUniqueId().equals(this.getUniqueId())) {
            throw new IllegalArgumentException("UUIDs do not match");
        }
        this.player = adaptedPlayer;
    }

    @Override
    public int getPriority() {
        return this.highestPriority;
    }

    @Override
    public boolean hasPriority() {
        return this.highestPriority > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimeSinceOnline() {
        if (this.player != null && this.player.isConnected()) {
            return 0L;
        }
        return System.currentTimeMillis() - this.leaveTime;
    }

    @Override
    public int getMaxOfflineTime() {
        return this.maxOfflineTime;
    }

    public void setLeaveTime(long l) {
        this.leaveTime = l;
    }
}

