/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.bstats.bungeecord;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import us.ajg0702.queue.libs.bstats.MetricsBase;
import us.ajg0702.queue.libs.bstats.charts.CustomChart;
import us.ajg0702.queue.libs.bstats.json.JsonObjectBuilder;

public class Metrics {
    private final Plugin plugin;
    private final MetricsBase metricsBase;
    private boolean enabled;
    private String serverUUID;
    private boolean logErrors = false;
    private boolean logSentData;
    private boolean logResponseStatusText;

    public Metrics(Plugin plugin, int n) {
        this.plugin = plugin;
        try {
            this.loadConfig();
        }
        catch (IOException iOException) {
            plugin.getLogger().log(Level.WARNING, "Failed to load bStats config!", iOException);
            this.metricsBase = null;
            return;
        }
        this.metricsBase = new MetricsBase("bungeecord", this.serverUUID, n, this.enabled, this::appendPlatformData, this::appendServiceData, null, () -> true, (string, throwable) -> this.plugin.getLogger().log(Level.WARNING, (String)string, (Throwable)throwable), string -> this.plugin.getLogger().log(Level.INFO, (String)string), this.logErrors, this.logSentData, this.logResponseStatusText);
    }

    private void loadConfig() {
        File file = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        file.mkdirs();
        File file2 = new File(file, "config.yml");
        if (!file2.exists()) {
            this.writeFile(file2, "# bStats (https://bStats.org) collects some basic information for plugin authors, like how", "# many people use their plugin and their total player count. It's recommended to keep bStats", "# enabled, but if you're not comfortable with this, you can turn this setting off. There is no", "# performance penalty associated with having metrics enabled, and data sent to bStats is fully", "# anonymous.", "enabled: true", "serverUuid: \"" + UUID.randomUUID() + "\"", "logFailedRequests: false", "logSentData: false", "logResponseStatusText: false");
        }
        Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file2);
        this.enabled = configuration.getBoolean("enabled", true);
        this.serverUUID = configuration.getString("serverUuid");
        this.logErrors = configuration.getBoolean("logFailedRequests", false);
        this.logSentData = configuration.getBoolean("logSentData", false);
        this.logResponseStatusText = configuration.getBoolean("logResponseStatusText", false);
    }

    private void writeFile(File file, String ... stringArray) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            for (String string : stringArray) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
    }

    public void addCustomChart(CustomChart customChart) {
        this.metricsBase.addCustomChart(customChart);
    }

    private void appendPlatformData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("playerAmount", this.plugin.getProxy().getOnlineCount());
        jsonObjectBuilder.appendField("managedServers", this.plugin.getProxy().getServers().size());
        jsonObjectBuilder.appendField("onlineMode", this.plugin.getProxy().getConfig().isOnlineMode() ? 1 : 0);
        jsonObjectBuilder.appendField("bungeecordVersion", this.plugin.getProxy().getVersion());
        jsonObjectBuilder.appendField("javaVersion", System.getProperty("java.version"));
        jsonObjectBuilder.appendField("osName", System.getProperty("os.name"));
        jsonObjectBuilder.appendField("osArch", System.getProperty("os.arch"));
        jsonObjectBuilder.appendField("osVersion", System.getProperty("os.version"));
        jsonObjectBuilder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("pluginVersion", this.plugin.getDescription().getVersion());
    }
}

