/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.AutoValue_ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializerCollection;
import us.ajg0702.queue.libs.sponge.configurate.util.MapFactories;
import us.ajg0702.queue.libs.sponge.configurate.util.MapFactory;
import us.ajg0702.queue.libs.sponge.configurate.util.Types;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

@CheckReturnValue
@AutoValue
public abstract class ConfigurationOptions {
    ConfigurationOptions() {
    }

    public static ConfigurationOptions defaults() {
        return Lazy.DEFAULTS;
    }

    public abstract MapFactory mapFactory();

    public ConfigurationOptions mapFactory(MapFactory mapFactory) {
        Objects.requireNonNull(mapFactory, "mapFactory");
        if (this.mapFactory() == mapFactory) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(mapFactory, this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract @Nullable String header();

    public ConfigurationOptions header(@Nullable String string) {
        if (Objects.equals(this.header(), string)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), string, this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract TypeSerializerCollection serializers();

    public ConfigurationOptions serializers(TypeSerializerCollection typeSerializerCollection) {
        Objects.requireNonNull(typeSerializerCollection, "serializers");
        if (this.serializers().equals(typeSerializerCollection)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), typeSerializerCollection, this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final ConfigurationOptions serializers(Consumer<TypeSerializerCollection.Builder> consumer) {
        Objects.requireNonNull(consumer, "serializerBuilder");
        TypeSerializerCollection.Builder builder = this.serializers().childBuilder();
        consumer.accept(builder);
        return this.serializers(builder.build());
    }

    abstract @Nullable Set<Class<?>> nativeTypes();

    public ConfigurationOptions nativeTypes(@Nullable Set<Class<?>> set) {
        if (Objects.equals(this.nativeTypes(), set)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), set == null ? null : UnmodifiableCollections.copyOf(set), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final boolean acceptsType(Class<?> clazz) {
        Objects.requireNonNull(clazz, "type");
        @Nullable Set<Class<?>> set = this.nativeTypes();
        if (set == null) {
            return true;
        }
        if (set.contains(clazz)) {
            return true;
        }
        if (clazz.isPrimitive() && set.contains(Types.box(clazz))) {
            return true;
        }
        Type type = Types.unbox(clazz);
        if (type != clazz && set.contains(type)) {
            return true;
        }
        for (Class<?> clazz2 : set) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean shouldCopyDefaults();

    public ConfigurationOptions shouldCopyDefaults(boolean bl) {
        if (this.shouldCopyDefaults() == bl) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), bl, this.implicitInitialization());
    }

    public abstract boolean implicitInitialization();

    public ConfigurationOptions implicitInitialization(boolean bl) {
        if (this.implicitInitialization() == bl) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), bl);
    }

    static class Lazy {
        static final ConfigurationOptions DEFAULTS = new AutoValue_ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializerCollection.defaults(), null, true, true);

        Lazy() {
        }
    }
}

