/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;

final class NodePathImpl
implements NodePath {
    static final NodePath EMPTY = new NodePathImpl(new Object[0], false);
    private final Object[] arr;

    NodePathImpl(Object[] objectArray, boolean bl) {
        Objects.requireNonNull(objectArray);
        this.arr = bl ? Arrays.copyOf(objectArray, objectArray.length) : objectArray;
    }

    @Override
    public Object get(int n) {
        return this.arr[n];
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public NodePath withAppendedChild(Object object) {
        Objects.requireNonNull(object, "childKey");
        Object[] objectArray = this.arr;
        if (objectArray.length == 0) {
            return new NodePathImpl(new Object[]{object}, false);
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length + 1);
        objectArray2[objectArray2.length - 1] = object;
        return new NodePathImpl(objectArray2, false);
    }

    @Override
    public NodePath with(int n, Object object) {
        Objects.requireNonNull(object, "value");
        Object[] objectArray = this.arr;
        if (n < 0 || n >= objectArray.length) {
            throw new IndexOutOfBoundsException("Index " + n + " is not within limit of [0," + objectArray.length + ")");
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        objectArray2[n] = object;
        return new NodePathImpl(objectArray2, false);
    }

    @Override
    public NodePath plus(NodePath nodePath) {
        Objects.requireNonNull(nodePath, "other");
        if (this.arr.length == 0) {
            return nodePath;
        }
        if (nodePath.size() == 0) {
            return this;
        }
        Object[] objectArray = nodePath instanceof NodePathImpl ? ((NodePathImpl)nodePath).arr : nodePath.array();
        Object[] objectArray2 = new Object[this.arr.length + objectArray.length];
        System.arraycopy(this.arr, 0, objectArray2, 0, this.arr.length);
        System.arraycopy(objectArray, 0, objectArray2, this.arr.length, objectArray.length);
        return new NodePathImpl(objectArray2, false);
    }

    @Override
    public Object[] array() {
        return Arrays.copyOf(this.arr, this.arr.length);
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.arr).iterator();
    }

    @Override
    public NodePath copy() {
        return new NodePathImpl(this.arr, true);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodePathImpl nodePathImpl = (NodePathImpl)object;
        return Arrays.equals(this.arr, nodePathImpl.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        return Arrays.toString(this.arr);
    }
}

