/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.loader;

import com.google.errorprone.annotations.ForOverride;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.loader.AtomicFiles;
import us.ajg0702.queue.libs.sponge.configurate.loader.CommentHandler;
import us.ajg0702.queue.libs.sponge.configurate.loader.CommentHandlers;
import us.ajg0702.queue.libs.sponge.configurate.loader.ConfigurationLoader;
import us.ajg0702.queue.libs.sponge.configurate.loader.HeaderMode;
import us.ajg0702.queue.libs.sponge.configurate.loader.ParsingException;
import us.ajg0702.queue.libs.sponge.configurate.reference.ConfigurationReference;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

public abstract class AbstractConfigurationLoader<N extends ScopedConfigurationNode<N>>
implements ConfigurationLoader<N> {
    public static final String CONFIGURATE_LINE_SEPARATOR = "\n";
    public static final Pattern CONFIGURATE_LINE_PATTERN = Pattern.compile("\n");
    protected static final String SYSTEM_LINE_SEPARATOR = System.lineSeparator();
    protected final @Nullable Callable<BufferedReader> source;
    protected final @Nullable Callable<BufferedWriter> sink;
    private final List<CommentHandler> commentHandlers;
    private final HeaderMode headerMode;
    private final ConfigurationOptions defaultOptions;

    protected AbstractConfigurationLoader(Builder<?, ?> builder, CommentHandler[] commentHandlerArray) {
        this.source = builder.source();
        this.sink = builder.sink();
        this.headerMode = builder.headerMode();
        this.commentHandlers = UnmodifiableCollections.toList(commentHandlerArray);
        this.defaultOptions = builder.defaultOptions();
    }

    public CommentHandler defaultCommentHandler() {
        return this.commentHandlers.get(0);
    }

    @Override
    public ConfigurationReference<N> loadToReference() {
        return ConfigurationReference.fixed(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public N load(ConfigurationOptions configurationOptions) {
        if (this.source == null) {
            throw new ParsingException(-1, -1, "", "No source present to read from!", null);
        }
        try (BufferedReader bufferedReader = this.source.call();){
            Object object2;
            if ((this.headerMode == HeaderMode.PRESERVE || this.headerMode == HeaderMode.NONE) && (object2 = CommentHandlers.extractComment(bufferedReader, this.commentHandlers)) != null && ((String)object2).length() > 0) {
                configurationOptions = configurationOptions.header((String)object2);
            }
            object2 = (ScopedConfigurationNode)this.createNode(configurationOptions);
            this.loadInternal(object2, bufferedReader);
            Object object = object2;
            return (N)object;
        }
        catch (ParsingException parsingException) {
            throw parsingException;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return (N)((ScopedConfigurationNode)this.createNode(configurationOptions));
        }
        catch (IOException iOException) {
            throw new ParsingException(-1, -1, configurationOptions.header(), null, iOException);
        }
        catch (Exception exception) {
            throw new ParsingException(-1, -1, configurationOptions.header(), "Unknown error occurred while loading", exception);
        }
    }

    @ForOverride
    protected abstract void loadInternal(N var1, BufferedReader var2);

    @Override
    public void save(ConfigurationNode configurationNode) {
        if (this.sink == null) {
            throw new ConfigurateException(configurationNode, "No sink present to write to!");
        }
        this.checkCanWrite(configurationNode);
        try (Writer writer = this.sink.call();){
            String string;
            this.writeHeaderInternal(writer);
            if (this.headerMode != HeaderMode.NONE && (string = configurationNode.options().header()) != null && !string.isEmpty()) {
                Iterator iterator = this.defaultCommentHandler().toComment(CONFIGURATE_LINE_PATTERN.splitAsStream(string)).iterator();
                while (iterator.hasNext()) {
                    writer.write((String)iterator.next());
                    writer.write(SYSTEM_LINE_SEPARATOR);
                }
                writer.write(SYSTEM_LINE_SEPARATOR);
            }
            this.saveInternal(configurationNode, writer);
        }
        catch (ConfigurateException configurateException) {
            throw configurateException;
        }
        catch (Exception exception) {
            throw new ConfigurateException(configurationNode, (Throwable)exception);
        }
    }

    @ForOverride
    protected void checkCanWrite(ConfigurationNode configurationNode) {
    }

    @ForOverride
    protected void writeHeaderInternal(Writer writer) {
    }

    @ForOverride
    protected abstract void saveInternal(ConfigurationNode var1, Writer var2);

    @Override
    public ConfigurationOptions defaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public final boolean canLoad() {
        return this.source != null;
    }

    @Override
    public final boolean canSave() {
        return this.sink != null;
    }

    public static abstract class Builder<T extends Builder<T, L>, L extends AbstractConfigurationLoader<?>> {
        protected HeaderMode headerMode = HeaderMode.PRESERVE;
        protected @Nullable Callable<BufferedReader> source;
        protected @Nullable Callable<BufferedWriter> sink;
        protected ConfigurationOptions defaultOptions = ConfigurationOptions.defaults();

        protected Builder() {
        }

        private T self() {
            return (T)this;
        }

        public T file(File file) {
            return this.path(Objects.requireNonNull(file, "file").toPath());
        }

        public T path(Path path) {
            Path path2 = Objects.requireNonNull(path, "path").toAbsolutePath();
            this.source = () -> Files.newBufferedReader(path2, StandardCharsets.UTF_8);
            this.sink = AtomicFiles.atomicWriterFactory(path2, StandardCharsets.UTF_8);
            return this.self();
        }

        public T url(URL uRL) {
            Objects.requireNonNull(uRL, "url");
            this.source = () -> new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream(), StandardCharsets.UTF_8));
            return this.self();
        }

        public T source(@Nullable Callable<BufferedReader> callable) {
            this.source = callable;
            return this.self();
        }

        public @Nullable Callable<BufferedReader> source() {
            return this.source;
        }

        public T sink(@Nullable Callable<BufferedWriter> callable) {
            this.sink = callable;
            return this.self();
        }

        public @Nullable Callable<BufferedWriter> sink() {
            return this.sink;
        }

        public T headerMode(HeaderMode headerMode) {
            this.headerMode = Objects.requireNonNull(headerMode, "mode");
            return this.self();
        }

        public HeaderMode headerMode() {
            return this.headerMode;
        }

        public T defaultOptions(ConfigurationOptions configurationOptions) {
            this.defaultOptions = Objects.requireNonNull(configurationOptions, "defaultOptions");
            return this.self();
        }

        public T defaultOptions(UnaryOperator<ConfigurationOptions> unaryOperator) {
            this.defaultOptions = Objects.requireNonNull((ConfigurationOptions)unaryOperator.apply(this.defaultOptions), "defaultOptions (updated)");
            return this.self();
        }

        public ConfigurationOptions defaultOptions() {
            return this.defaultOptions;
        }

        public abstract L build();

        public ConfigurationNode buildAndLoadString(String string) {
            return ((Builder)this.source(() -> new BufferedReader(new StringReader(string)))).build().load();
        }

        public String buildAndSaveString(ConfigurationNode configurationNode) {
            Objects.requireNonNull(configurationNode, "output");
            StringWriter stringWriter = new StringWriter();
            ((AbstractConfigurationLoader)((Builder)this.sink(() -> new BufferedWriter(stringWriter))).build()).save(configurationNode);
            return stringWriter.toString();
        }
    }
}

