/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.loader;

import java.io.IOException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;

public class ParsingException
extends ConfigurateException {
    public static final int UNKNOWN_POS = -1;
    private static final char POSITION_MARKER = '^';
    private static final long serialVersionUID = 8379206111053602577L;
    private final int line;
    private final int column;
    private final @Nullable String context;

    public static ParsingException wrap(ConfigurationNode configurationNode, IOException iOException) {
        if (iOException instanceof ParsingException) {
            return (ParsingException)iOException;
        }
        return new ParsingException(configurationNode, -1, -1, null, null, iOException);
    }

    public ParsingException(ConfigurationNode configurationNode, int n, int n2, String string, @Nullable String string2) {
        this(configurationNode, n, n2, string, string2, null);
    }

    public ParsingException(int n, int n2, @Nullable String string, @Nullable String string2, @Nullable Throwable throwable) {
        super(string2, throwable);
        this.line = n;
        this.column = n2;
        this.context = string;
    }

    public ParsingException(ConfigurationNode configurationNode, int n, int n2, @Nullable String string, @Nullable String string2, @Nullable Throwable throwable) {
        super(configurationNode, string2, throwable);
        this.line = n;
        this.column = n2;
        this.context = string;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public @Nullable String context() {
        return this.context;
    }

    @Override
    public @Nullable String getMessage() {
        if (this.line == -1 || this.column == -1) {
            return super.getMessage();
        }
        @Nullable String string = this.rawMessage();
        StringBuilder stringBuilder = new StringBuilder(string == null ? 0 : string.length() + 20);
        stringBuilder.append(this.path()).append("@(line ").append(this.line).append(", col ").append(this.column).append("): ").append(string);
        if (this.context != null) {
            stringBuilder.append(System.lineSeparator()).append(this.context);
            if (this.column >= 0 && this.column < this.context.length()) {
                stringBuilder.append(System.lineSeparator());
                if (this.column > 0) {
                    char[] cArray = new char[this.column - 1];
                    Arrays.fill(cArray, ' ');
                    stringBuilder.append(cArray);
                }
                stringBuilder.append('^');
            }
        }
        return stringBuilder.toString();
    }
}

