/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.objectmapping;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.FieldDiscoverer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;
import us.ajg0702.queue.libs.sponge.configurate.util.Types;

class ObjectFieldDiscoverer
implements FieldDiscoverer<Map<Field, Object>> {
    static final ObjectFieldDiscoverer EMPTY_CONSTRUCTOR_INSTANCE = new ObjectFieldDiscoverer(annotatedType -> {
        try {
            Constructor<?> constructor = GenericTypeReflector.erase(annotatedType.getType()).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }, "Objects must have a zero-argument constructor to be able to create new instances");
    private final CheckedFunction<AnnotatedType, @Nullable Supplier<Object>, SerializationException> instanceFactory;
    private final String instanceUnavailableErrorMessage;

    ObjectFieldDiscoverer(CheckedFunction<AnnotatedType, @Nullable Supplier<Object>, SerializationException> checkedFunction, @Nullable String string) {
        this.instanceFactory = checkedFunction;
        this.instanceUnavailableErrorMessage = string == null ? "Unable to create instances for this type!" : string;
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<Map<Field, Object>> discover(final AnnotatedType annotatedType, FieldDiscoverer.FieldCollector<Map<Field, Object>, V> fieldCollector) {
        Class<?> clazz = GenericTypeReflector.erase(annotatedType.getType());
        if (clazz.isInterface()) {
            throw new SerializationException(annotatedType.getType(), "ObjectMapper can only work with concrete types");
        }
        final @Nullable Supplier<Object> supplier = this.instanceFactory.apply(annotatedType);
        AnnotatedType annotatedType2 = annotatedType;
        Class<?> clazz2 = clazz;
        while (true) {
            this.collectFields(annotatedType2, fieldCollector);
            clazz2 = clazz2.getSuperclass();
            if (clazz2.equals(Object.class)) break;
            annotatedType2 = GenericTypeReflector.getExactSuperType(annotatedType2, clazz2);
        }
        return new FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>>(){

            @Override
            public Map<Field, Object> begin() {
                return new HashMap<Field, Object>();
            }

            @Override
            public void complete(Object object, Map<Field, Object> map) {
                for (Map.Entry<Field, Object> entry : map.entrySet()) {
                    try {
                        if (entry.getValue() instanceof ImplicitProvider) {
                            @Nullable Object object2 = ((ImplicitProvider)entry.getValue()).provider.get();
                            if (object2 == null || entry.getKey().get(object) != null) continue;
                            entry.getKey().set(object, object2);
                            continue;
                        }
                        entry.getKey().set(object, entry.getValue());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SerializationException(annotatedType.getType(), (Throwable)illegalAccessException);
                    }
                }
            }

            @Override
            public Object complete(Map<Field, Object> map) {
                Object var2_2;
                Object v0 = var2_2 = supplier == null ? null : supplier.get();
                if (var2_2 == null) {
                    throw new SerializationException(annotatedType.getType(), ObjectFieldDiscoverer.this.instanceUnavailableErrorMessage);
                }
                this.complete((Object)var2_2, map);
                return var2_2;
            }

            @Override
            public boolean canCreateInstances() {
                return supplier != null;
            }
        };
    }

    private void collectFields(AnnotatedType annotatedType, FieldDiscoverer.FieldCollector<Map<Field, Object>, ?> fieldCollector) {
        for (Field field : GenericTypeReflector.erase(annotatedType.getType()).getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            AnnotatedType annotatedType2 = GenericTypeReflector.getFieldType(field, annotatedType);
            fieldCollector.accept(field.getName(), annotatedType2, Types.combinedAnnotations(annotatedType2, field), (map, object, supplier) -> {
                if (object != null) {
                    map.put(field, object);
                } else {
                    map.put(field, new ImplicitProvider(supplier));
                }
            }, field::get);
        }
    }

    static class ImplicitProvider {
        final Supplier<Object> provider;

        ImplicitProvider(Supplier<Object> supplier) {
            this.provider = supplier;
        }
    }
}

