/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reactive;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.NoOpDisposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Processor;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;

abstract class AbstractProcessor<V, R extends Registration<V>>
implements Processor.Iso<V> {
    private static final int CLOSED_VALUE = -1073741824;
    final AtomicInteger subscriberCount = new AtomicInteger();
    volatile @Nullable Subscriber<V> fallbackHandler;
    protected final Set<R> registrations = ConcurrentHashMap.newKeySet();
    protected final Executor executor;

    protected AbstractProcessor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    protected abstract R createRegistration(Subscriber<? super V> var1);

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        if (this.subscriberCount.get() < 0 || this.subscriberCount.incrementAndGet() <= 0) {
            subscriber.onError(new IllegalStateException("Processor " + this + " is already closed!"));
            this.subscriberCount.set(-1073741824);
            return NoOpDisposable.INSTANCE;
        }
        R r = this.createRegistration(subscriber);
        this.registrations.add(r);
        return r;
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscriberCount.get() > 0;
    }

    @Override
    public void onError(Throwable throwable) {
        Processor.Iso.super.onError(throwable);
        this.onClose();
    }

    @Override
    public void onClose() {
        this.executor.execute(() -> {
            this.subscriberCount.set(-1073741824);
            for (Registration registration : this.registrations) {
                try {
                    registration.onClose();
                }
                catch (Exception exception) {}
            }
            this.registrations.clear();
        });
    }

    protected void forEachOrRemove(Consumer<R> consumer) {
        Iterator<R> iterator = this.registrations.iterator();
        while (iterator.hasNext()) {
            Registration registration = (Registration)iterator.next();
            try {
                consumer.accept(registration);
            }
            catch (Exception exception) {
                iterator.remove();
                this.subscriberCount.getAndDecrement();
                try {
                    registration.onError(exception);
                }
                catch (Exception exception2) {
                    Processor.Iso.super.onError(exception2);
                }
            }
        }
    }

    @Override
    public void fallbackHandler(@Nullable Subscriber<V> subscriber) {
        this.fallbackHandler = subscriber;
    }

    @Override
    public boolean closeIfUnsubscribed() {
        this.executor.execute(() -> {
            if (this.subscriberCount.compareAndSet(0, -1073741824)) {
                for (Registration registration : this.registrations) {
                    registration.onClose();
                }
                this.registrations.clear();
            }
        });
        return this.subscriberCount.get() <= 0;
    }

    protected static interface Registration<V>
    extends Disposable {
        public void submit(V var1);

        public void onClose();

        public void onError(Throwable var1);
    }
}

