/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reactive;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.NoOpDisposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Publisher;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;

class CachedPublisher<V>
implements Publisher.Cached<V>,
AutoCloseable {
    private final Publisher<V> parent;
    private final Set<Subscriber<? super V>> subscribers = ConcurrentHashMap.newKeySet();
    private volatile @MonotonicNonNull V value;
    private final Disposable closer;

    CachedPublisher(Publisher<V> publisher, @Nullable V v) {
        this.parent = publisher;
        if (v != null) {
            this.value = v;
        }
        this.closer = this.parent.subscribe(object -> {
            this.value = object;
        });
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        Disposable disposable = this.parent.subscribe(subscriber);
        if (disposable != NoOpDisposable.INSTANCE) {
            this.subscribers.add(subscriber);
            V v = this.value;
            if (v != null) {
                subscriber.submit(v);
            }
            return () -> {
                this.subscribers.remove(subscriber);
                disposable.dispose();
            };
        }
        return disposable;
    }

    @Override
    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    @Override
    public Publisher.Cached<V> cache() {
        return this;
    }

    @Override
    public Publisher.Cached<V> cache(@Nullable V v) {
        if (this.value == null && v != null) {
            this.value = v;
        }
        return this;
    }

    @Override
    public Executor executor() {
        return this.parent.executor();
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public void submit(V v) {
        this.value = v;
        this.subscribers.forEach(subscriber -> subscriber.submit(v));
    }

    @Override
    public void close() {
        this.closer.dispose();
    }
}

