/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reference;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.loader.ConfigurationLoader;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;
import us.ajg0702.queue.libs.sponge.configurate.reference.ConfigurationReference;
import us.ajg0702.queue.libs.sponge.configurate.reference.DirectoryListenerRegistration;
import us.ajg0702.queue.libs.sponge.configurate.reference.PrefixedNameThreadFactory;

public final class WatchServiceListener
implements AutoCloseable {
    private static final WatchEvent.Kind<?>[] DEFAULT_WATCH_EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private static final int PARALLEL_THRESHOLD = 100;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new PrefixedNameThreadFactory("Configurate-WatchService", true);
    private final WatchService watchService;
    private volatile boolean open = true;
    private final Thread executor;
    final Executor taskExecutor;
    private final ConcurrentHashMap<Path, DirectoryListenerRegistration> activeListeners = new ConcurrentHashMap();
    private static final ThreadLocal<IOException> exceptionHolder = new ThreadLocal();

    public static Builder builder() {
        return new Builder();
    }

    public static WatchServiceListener create() {
        return new WatchServiceListener(DEFAULT_THREAD_FACTORY, FileSystems.getDefault(), ForkJoinPool.commonPool());
    }

    private WatchServiceListener(ThreadFactory threadFactory, FileSystem fileSystem, Executor executor) {
        this.watchService = fileSystem.newWatchService();
        this.executor = threadFactory.newThread(() -> {
            while (this.open) {
                WatchKey watchKey;
                try {
                    watchKey = this.watchService.take();
                }
                catch (InterruptedException interruptedException) {
                    this.open = false;
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    break;
                }
                Path path = (Path)watchKey.watchable();
                DirectoryListenerRegistration directoryListenerRegistration = this.activeListeners.get(path);
                if (directoryListenerRegistration != null) {
                    HashSet hashSet = new HashSet();
                    for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                        if (!watchKey.isValid()) break;
                        if (!hashSet.add(watchEvent.context())) continue;
                        directoryListenerRegistration.submit(watchEvent);
                        if (!directoryListenerRegistration.closeIfEmpty()) continue;
                        watchKey.cancel();
                        break;
                    }
                    if (!watchKey.reset()) {
                        DirectoryListenerRegistration directoryListenerRegistration2 = this.activeListeners.remove(path);
                        directoryListenerRegistration2.onClose();
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        this.taskExecutor = executor;
        this.executor.start();
    }

    private DirectoryListenerRegistration registration(Path path2) {
        @Nullable DirectoryListenerRegistration directoryListenerRegistration = this.activeListeners.computeIfAbsent(path2, path -> {
            try {
                return new DirectoryListenerRegistration(path.register(this.watchService, DEFAULT_WATCH_EVENTS), this.taskExecutor);
            }
            catch (IOException iOException) {
                exceptionHolder.set(iOException);
                return null;
            }
        });
        if (directoryListenerRegistration == null) {
            throw new ConfigurateException("While adding listener for " + path2, (Throwable)exceptionHolder.get());
        }
        return directoryListenerRegistration;
    }

    public Disposable listenToFile(Path path, Subscriber<WatchEvent<?>> subscriber) {
        if (Files.isDirectory(path = path.toAbsolutePath(), new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path + " must be a file");
        }
        Path path2 = path.getFileName();
        return this.registration(path.getParent()).subscribe(path2, subscriber);
    }

    public Disposable listenToDirectory(Path path, Subscriber<WatchEvent<?>> subscriber) {
        if (!Files.isDirectory(path = path.toAbsolutePath(), new LinkOption[0]) && Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path + " must be a directory");
        }
        return this.registration(path).subscribe(subscriber);
    }

    public <N extends ScopedConfigurationNode<N>> ConfigurationReference<N> listenToConfiguration(Function<Path, ConfigurationLoader<? extends N>> function, Path path) {
        return ConfigurationReference.watching(function, path, this);
    }

    @Override
    public void close() {
        this.open = false;
        this.watchService.close();
        this.activeListeners.forEachValue(100L, DirectoryListenerRegistration::onClose);
        this.activeListeners.clear();
        try {
            this.executor.interrupt();
            this.executor.join();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Failed to await termination of executor thread!");
        }
    }

    public static final class Builder {
        private @Nullable ThreadFactory threadFactory;
        private @Nullable FileSystem fileSystem;
        private @Nullable Executor taskExecutor;

        private Builder() {
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = Objects.requireNonNull(threadFactory, "factory");
            return this;
        }

        public Builder taskExecutor(Executor executor) {
            this.taskExecutor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public WatchServiceListener build() {
            if (this.threadFactory == null) {
                this.threadFactory = DEFAULT_THREAD_FACTORY;
            }
            if (this.fileSystem == null) {
                this.fileSystem = FileSystems.getDefault();
            }
            if (this.taskExecutor == null) {
                this.taskExecutor = ForkJoinPool.commonPool();
            }
            return new WatchServiceListener(this.threadFactory, this.fileSystem, this.taskExecutor);
        }
    }
}

