/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.serialize.AbstractListChildSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.Scalars;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedConsumer;
import us.ajg0702.queue.libs.sponge.configurate.util.Types;

abstract class ArraySerializer<T>
extends AbstractListChildSerializer<T> {
    ArraySerializer() {
    }

    @Override
    protected Type elementType(Type type) {
        Type type2 = GenericTypeReflector.getArrayComponentType(type);
        if (type2 == null) {
            throw new SerializationException(type, "Must be array type");
        }
        return type2;
    }

    static final class Doubles
    extends ArraySerializer<double[]> {
        static final Class<double[]> TYPE = double[].class;

        Doubles() {
        }

        @Override
        protected double[] createNew(int n, Type type) {
            return new double[n];
        }

        @Override
        protected void forEachElement(double[] dArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (double d : dArray) {
                checkedConsumer.accept(d);
            }
        }

        @Override
        protected void deserializeSingle(int n, double[] dArray, @Nullable Object object) {
            dArray[n] = object == null ? 0.0 : Scalars.DOUBLE.deserialize(object);
        }
    }

    static final class Floats
    extends ArraySerializer<float[]> {
        static final Class<float[]> TYPE = float[].class;

        Floats() {
        }

        @Override
        protected float[] createNew(int n, Type type) {
            return new float[n];
        }

        @Override
        protected void forEachElement(float[] fArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (float f : fArray) {
                checkedConsumer.accept(Float.valueOf(f));
            }
        }

        @Override
        protected void deserializeSingle(int n, float[] fArray, @Nullable Object object) {
            fArray[n] = object == null ? 0.0f : Scalars.FLOAT.deserialize(object).floatValue();
        }
    }

    static final class Longs
    extends ArraySerializer<long[]> {
        static final Class<long[]> TYPE = long[].class;

        Longs() {
        }

        @Override
        protected long[] createNew(int n, Type type) {
            return new long[n];
        }

        @Override
        protected void forEachElement(long[] lArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (long l : lArray) {
                checkedConsumer.accept(l);
            }
        }

        @Override
        protected void deserializeSingle(int n, long[] lArray, @Nullable Object object) {
            lArray[n] = object == null ? 0L : Scalars.LONG.deserialize(object);
        }
    }

    static final class Ints
    extends ArraySerializer<int[]> {
        static final Class<int[]> TYPE = int[].class;

        Ints() {
        }

        @Override
        protected int[] createNew(int n, Type type) {
            return new int[n];
        }

        @Override
        protected void forEachElement(int[] nArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (int n : nArray) {
                checkedConsumer.accept(n);
            }
        }

        @Override
        protected void deserializeSingle(int n, int[] nArray, @Nullable Object object) {
            nArray[n] = object == null ? 0 : Scalars.INTEGER.deserialize(object);
        }
    }

    static final class Shorts
    extends ArraySerializer<short[]> {
        static final Class<short[]> TYPE = short[].class;

        Shorts() {
        }

        @Override
        protected short[] createNew(int n, Type type) {
            return new short[n];
        }

        @Override
        protected void forEachElement(short[] sArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (short s : sArray) {
                checkedConsumer.accept(s);
            }
        }

        @Override
        protected void deserializeSingle(int n, short[] sArray, @Nullable Object object) {
            sArray[n] = object == null ? (short)0 : Scalars.INTEGER.deserialize(object).shortValue();
        }
    }

    static final class Chars
    extends ArraySerializer<char[]> {
        static final Class<char[]> TYPE = char[].class;

        Chars() {
        }

        @Override
        protected char[] createNew(int n, Type type) {
            return new char[n];
        }

        @Override
        protected void forEachElement(char[] cArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (char c : cArray) {
                checkedConsumer.accept(Character.valueOf(c));
            }
        }

        @Override
        protected void deserializeSingle(int n, char[] cArray, @Nullable Object object) {
            cArray[n] = object == null ? (char)'\u0000' : Scalars.CHAR.deserialize(object).charValue();
        }
    }

    static final class Bytes
    extends ArraySerializer<byte[]> {
        static final Class<byte[]> TYPE = byte[].class;

        Bytes() {
        }

        @Override
        protected byte[] createNew(int n, Type type) {
            return new byte[n];
        }

        @Override
        protected void forEachElement(byte[] byArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (byte by : byArray) {
                checkedConsumer.accept(by);
            }
        }

        @Override
        protected void deserializeSingle(int n, byte[] byArray, @Nullable Object object) {
            byArray[n] = object == null ? (byte)0 : Scalars.INTEGER.deserialize(object).byteValue();
        }
    }

    static final class Booleans
    extends ArraySerializer<boolean[]> {
        static final Class<boolean[]> TYPE = boolean[].class;

        Booleans() {
        }

        @Override
        protected boolean[] createNew(int n, Type type) {
            return new boolean[n];
        }

        @Override
        protected void forEachElement(boolean[] blArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (boolean bl : blArray) {
                checkedConsumer.accept(bl);
            }
        }

        @Override
        protected void deserializeSingle(int n, boolean[] blArray, @Nullable Object object) {
            blArray[n] = object == null ? false : Scalars.BOOLEAN.deserialize(object);
        }
    }

    static final class Objects
    extends ArraySerializer<Object[]> {
        Objects() {
        }

        public static boolean accepts(Type type) {
            if (!Types.isArray(type)) {
                return false;
            }
            Type type2 = GenericTypeReflector.getArrayComponentType(type);
            return type2.equals(GenericTypeReflector.box(type2));
        }

        @Override
        protected Object[] createNew(int n, Type type) {
            return (Object[])Array.newInstance(GenericTypeReflector.erase(type), n);
        }

        @Override
        protected void forEachElement(Object[] objectArray, CheckedConsumer<Object, SerializationException> checkedConsumer) {
            for (Object object : objectArray) {
                checkedConsumer.accept(object);
            }
        }

        @Override
        protected void deserializeSingle(int n, Object[] objectArray, @Nullable Object object) {
            objectArray[n] = object;
        }
    }
}

