/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Predicate;
import us.ajg0702.queue.libs.sponge.configurate.serialize.CoercionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;

final class BooleanSerializer
extends ScalarSerializer<Boolean> {
    BooleanSerializer() {
        super(Boolean.class);
    }

    @Override
    public Boolean deserialize(Type type, Object object) {
        if (object instanceof Number) {
            return !object.equals(0);
        }
        String string = object.toString().toLowerCase(Locale.ROOT);
        if (string.equals("true") || string.equals("t") || string.equals("yes") || string.equals("y") || string.equals("1")) {
            return true;
        }
        if (string.equals("false") || string.equals("f") || string.equals("no") || string.equals("n") || string.equals("0")) {
            return false;
        }
        throw new CoercionFailedException(type, object, "boolean");
    }

    @Override
    public Object serialize(Boolean bl, Predicate<Class<?>> predicate) {
        if (predicate.test(Integer.class)) {
            return bl != false ? 1 : 0;
        }
        return bl.toString();
    }
}

