/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.EnumLookup;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object object) {
        String string = object.toString();
        @Nullable Enum enum_ = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), string);
        if (enum_ == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + string);
        }
        return enum_;
    }

    @Override
    public Object serialize(Enum<?> enum_, Predicate<Class<?>> predicate) {
        return enum_.name();
    }
}

