/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.BasicConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;

final class MapSerializer
implements TypeSerializer<Map<?, ?>> {
    static final TypeToken<Map<?, ?>> TYPE = new TypeToken<Map<?, ?>>(){};

    MapSerializer() {
    }

    @Override
    public Map<?, ?> deserialize(Type type, ConfigurationNode configurationNode) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (configurationNode.isMap()) {
            if (!(type instanceof ParameterizedType)) {
                throw new SerializationException(type, "Raw types are not supported for collections");
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length != 2) {
                throw new SerializationException(type, "Map expected two type arguments!");
            }
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            Type type3 = parameterizedType.getActualTypeArguments()[1];
            @Nullable TypeSerializer<?> typeSerializer = configurationNode.options().serializers().get(type2);
            @Nullable TypeSerializer<?> typeSerializer2 = configurationNode.options().serializers().get(type3);
            if (typeSerializer == null) {
                throw new SerializationException(type, "No type serializer available for key type " + type2);
            }
            if (typeSerializer2 == null) {
                throw new SerializationException(type, "No type serializer available for value type " + type3);
            }
            BasicConfigurationNode basicConfigurationNode = BasicConfigurationNode.root(configurationNode.options());
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode.childrenMap().entrySet()) {
                linkedHashMap.put(Objects.requireNonNull(typeSerializer.deserialize(type2, basicConfigurationNode.set(entry.getKey())), "key"), Objects.requireNonNull(typeSerializer2.deserialize(type3, entry.getValue()), "value"));
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Type type, @Nullable Map<?, ?> map, ConfigurationNode configurationNode) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        Type type3 = parameterizedType.getActualTypeArguments()[1];
        @Nullable TypeSerializer<?> typeSerializer = configurationNode.options().serializers().get(type2);
        @Nullable TypeSerializer<?> typeSerializer2 = configurationNode.options().serializers().get(type3);
        if (typeSerializer == null) {
            throw new SerializationException(type, "No type serializer available for key type " + type2);
        }
        if (typeSerializer2 == null) {
            throw new SerializationException(type, "No type serializer available for value type " + type3);
        }
        if (map == null || map.isEmpty()) {
            configurationNode.set(Collections.emptyMap());
        } else {
            Set<Map.Entry<Object, Object>> set;
            if (configurationNode.empty()) {
                configurationNode.raw(Collections.emptyMap());
                set = Collections.emptySet();
            } else {
                set = new HashSet<Object>(configurationNode.childrenMap().keySet());
            }
            BasicConfigurationNode basicConfigurationNode = BasicConfigurationNode.root(configurationNode.options());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                typeSerializer.serialize(type2, entry.getKey(), basicConfigurationNode);
                Object object = Objects.requireNonNull(basicConfigurationNode.raw(), "Key must not be null!");
                ConfigurationNode configurationNode2 = configurationNode.node(object);
                try {
                    typeSerializer2.serialize(type3, entry.getValue(), configurationNode2);
                }
                catch (SerializationException serializationException) {
                    serializationException.initPath(configurationNode2::path);
                }
                finally {
                    set.remove(object);
                }
            }
            for (Map.Entry<Object, Object> entry : set) {
                configurationNode.removeChild(entry);
            }
        }
    }

    @Override
    public Map<?, ?> emptyValue(Type type, ConfigurationOptions configurationOptions) {
        return new LinkedHashMap();
    }
}

