/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;

public abstract class ScalarSerializer<T>
implements TypeSerializer<T> {
    private final TypeToken<T> type;

    protected ScalarSerializer(TypeToken<T> typeToken) {
        Type type = GenericTypeReflector.box(typeToken.getType());
        this.type = type == typeToken.getType() ? typeToken : TypeToken.get(type);
    }

    protected ScalarSerializer(Class<T> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Provided type " + clazz + " has type parameters but was not provided as a TypeToken!");
        }
        this.type = TypeToken.get(clazz);
    }

    ScalarSerializer(Type type) {
        this.type = TypeToken.get(type);
    }

    public final TypeToken<T> type() {
        return this.type;
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode configurationNode) {
        Object object;
        ConfigurationNode configurationNode2 = configurationNode;
        if (configurationNode.isList() && (object = configurationNode.childrenList()).size() == 1) {
            configurationNode2 = object.get(0);
        }
        if (configurationNode2.isList() || configurationNode2.isMap()) {
            throw new SerializationException(type, "Value must be provided as a scalar!");
        }
        object = configurationNode2.rawScalar();
        if (object == null) {
            throw new SerializationException(type, "No scalar value present");
        }
        type = GenericTypeReflector.box(type);
        @Nullable T t = this.cast(object);
        if (t != null) {
            return t;
        }
        return this.deserialize(type, object);
    }

    public final T deserialize(Object object) {
        @Nullable T t = this.cast(object);
        if (t != null) {
            return t;
        }
        return this.deserialize(this.type().getType(), object);
    }

    public abstract T deserialize(Type var1, Object var2);

    @Override
    public final void serialize(Type type, @Nullable T t, ConfigurationNode configurationNode) {
        if (t == null) {
            configurationNode.raw(null);
            return;
        }
        if (configurationNode.options().acceptsType(t.getClass())) {
            configurationNode.raw(t);
            return;
        }
        configurationNode.raw(this.serialize(t, configurationNode.options()::acceptsType));
    }

    protected abstract Object serialize(T var1, Predicate<Class<?>> var2);

    private @Nullable T cast(Object object) {
        Class<?> clazz = GenericTypeReflector.erase(this.type().getType());
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        return null;
    }

    public final @Nullable T tryDeserialize(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.deserialize(object);
        }
        catch (SerializationException serializationException) {
            return null;
        }
    }

    public final String serializeToString(T t) {
        if (t instanceof CharSequence) {
            return t.toString();
        }
        return (String)this.serialize(t, clazz -> clazz.isAssignableFrom(String.class));
    }
}

