/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.serialize.AbstractListChildSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedConsumer;

final class SetSerializer
extends AbstractListChildSerializer<Set<?>> {
    static boolean accepts(Type type) {
        Class<AbstractSet> clazz = GenericTypeReflector.erase(type);
        return Set.class.isAssignableFrom(clazz) && (clazz.isAssignableFrom(EnumSet.class) || clazz.isAssignableFrom(LinkedHashSet.class));
    }

    SetSerializer() {
    }

    @Override
    protected Type elementType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException("Raw types are not supported for collections");
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    @Override
    protected Set<?> createNew(int n, Type type) {
        Class<?> clazz = GenericTypeReflector.erase(type);
        if (clazz.isEnum()) {
            return EnumSet.noneOf(clazz.asSubclass(Enum.class));
        }
        return new LinkedHashSet(n);
    }

    @Override
    protected void forEachElement(Set<?> set, CheckedConsumer<Object, SerializationException> checkedConsumer) {
        for (Object obj : set) {
            checkedConsumer.accept(obj);
        }
    }

    @Override
    protected void deserializeSingle(int n, Set<?> set, @Nullable Object object) {
        set.add(object);
    }
}

