/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.transformation;

import java.util.Map;
import java.util.NavigableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.transformation.ConfigurationTransformation;

class VersionedTransformation
implements ConfigurationTransformation.Versioned {
    private final NodePath versionPath;
    private final NavigableMap<Integer, ConfigurationTransformation> versionTransformations;

    VersionedTransformation(NodePath nodePath, NavigableMap<Integer, ConfigurationTransformation> navigableMap) {
        this.versionPath = nodePath;
        this.versionTransformations = navigableMap;
    }

    @Override
    public void apply(ConfigurationNode configurationNode) {
        @Nullable ConfigurateException configurateException = null;
        ConfigurationNode configurationNode2 = configurationNode.node(this.versionPath);
        int n = configurationNode2.getInt(-1);
        for (Map.Entry entry : this.versionTransformations.entrySet()) {
            if ((Integer)entry.getKey() <= n) continue;
            try {
                ((ConfigurationTransformation)entry.getValue()).apply(configurationNode);
            }
            catch (ConfigurateException configurateException2) {
                if (configurateException == null) {
                    configurateException = configurateException2;
                }
                configurateException.addSuppressed(configurateException2);
            }
            n = (Integer)entry.getKey();
        }
        if (configurateException != null) {
            throw configurateException;
        }
        configurationNode2.set(n);
    }

    @Override
    public NodePath versionKey() {
        return this.versionPath;
    }

    @Override
    public int latestVersion() {
        return (Integer)this.versionTransformations.lastKey();
    }
}

