/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.ajg0702.queue.libs.sponge.configurate.util.NamingScheme;

public enum NamingSchemes implements NamingScheme
{
    PASSTHROUGH{

        @Override
        public String coerce(String string) {
            return string;
        }
    }
    ,
    CAMEL_CASE{

        @Override
        public String coerce(String string) {
            Matcher matcher = DASH_UNDERSCORE.matcher(string);
            if (!matcher.find()) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string.length());
            do {
                matcher.appendReplacement(stringBuffer, "");
                stringBuffer.appendCodePoint(string.codePointAt(matcher.start()));
                stringBuffer.appendCodePoint(Character.toUpperCase(string.codePointBefore(matcher.end())));
            } while (matcher.find());
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String coerce(String string) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(string, '_', '-');
        }
    }
    ,
    LOWER_CASE_DASHED{

        @Override
        public String coerce(String string) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(string, '-', '_');
        }
    };

    private static final Pattern DASH_UNDERSCORE;
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';

    private static String enforceLowerCaseSeparatorChar(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            int n = stringBuilder.codePointAt(i);
            if (n == c2) {
                if (i == 0 || i == stringBuilder.length() - 1) continue;
                stringBuilder.setCharAt(i, c);
                continue;
            }
            if (!Character.isUpperCase(n)) continue;
            stringBuilder.insert(i++, c);
            int n2 = Character.toLowerCase(n);
            if (Character.isBmpCodePoint(n2)) {
                stringBuilder.setCharAt(i, (char)n2);
                continue;
            }
            stringBuilder.setCharAt(i++, Character.highSurrogate(n2));
            stringBuilder.setCharAt(i, Character.lowSurrogate(n2));
        }
        return stringBuilder.toString();
    }

    static {
        DASH_UNDERSCORE = Pattern.compile(".[-_].");
    }
}

