/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class UnmodifiableCollections {
    private UnmodifiableCollections() {
    }

    public static <E> List<E> copyOf(List<E> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        return Collections.unmodifiableList(new ArrayList<E>(list));
    }

    public static <E> Set<E> copyOf(Set<E> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(set));
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        if (map instanceof LinkedHashMap) {
            return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    @SafeVarargs
    public static <E> List<E> toList(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(EArray[0]);
            }
        }
        return Collections.unmodifiableList(new ArrayList<E>(Arrays.asList(EArray)));
    }

    @SafeVarargs
    public static <E> Set<E> toSet(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(EArray)));
    }

    public static <K, V> Map<K, V> buildMap(Consumer<Map<K, V>> consumer) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Objects.requireNonNull(consumer, "handler").accept(linkedHashMap);
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public static <K, V> Map.Entry<K, V> immutableMapEntry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }
}

