/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.yaml;

import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.loader.AbstractConfigurationLoader;
import us.ajg0702.queue.libs.sponge.configurate.loader.CommentHandler;
import us.ajg0702.queue.libs.sponge.configurate.loader.CommentHandlers;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;
import us.ajg0702.queue.libs.sponge.configurate.yaml.ConfigurateYaml;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.yaml.snakeyaml.DumperOptions;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    private final ThreadLocal<ConfigurateYaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        DumperOptions dumperOptions = builder.options;
        dumperOptions.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        this.yaml = ThreadLocal.withInitial(() -> new ConfigurateYaml(dumperOptions));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode commentedConfigurationNode, BufferedReader bufferedReader) {
        commentedConfigurationNode.raw(this.yaml.get().loadConfigurate(bufferedReader));
    }

    @Override
    protected void saveInternal(ConfigurationNode configurationNode, Writer writer) {
        this.yaml.get().dump(configurationNode.raw(), writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions configurationOptions) {
        return CommentedConfigurationNode.root(configurationOptions);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;

        Builder() {
            this.indent(4);
            this.defaultOptions(configurationOptions -> configurationOptions.nativeTypes(NATIVE_TYPES));
        }

        public Builder indent(int n) {
            this.options.setIndent(n);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle nodeStyle) {
            this.style = nodeStyle;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

