/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.bungee;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeMessages {
    static BungeeMessages INSTANCE = null;
    Plugin pl;
    ConfigurationProvider cv = ConfigurationProvider.getProvider(YamlConfiguration.class);
    Configuration msgs;
    File msgFile;
    LinkedHashMap<String, String> defaultValues;

    public static BungeeMessages getInstance() {
        return INSTANCE;
    }

    public static BungeeMessages getInstance(Plugin plugin, LinkedHashMap<String, String> linkedHashMap) {
        if (INSTANCE == null) {
            INSTANCE = new BungeeMessages(plugin, linkedHashMap);
        }
        return INSTANCE;
    }

    private BungeeMessages(Plugin plugin, LinkedHashMap<String, String> linkedHashMap) {
        this.pl = plugin;
        this.defaultValues = linkedHashMap;
        this.loadMessagesFile(linkedHashMap);
    }

    private void loadMessagesFile(LinkedHashMap<String, String> linkedHashMap) {
        this.msgFile = new File(this.pl.getDataFolder(), "messages.yml");
        if (!this.msgFile.exists()) {
            try {
                this.pl.getDataFolder().mkdirs();
                this.msgFile.createNewFile();
            }
            catch (IOException iOException) {
                this.pl.getLogger().severe("Unable to create messages file:");
                iOException.printStackTrace();
            }
        }
        try {
            this.msgs = this.cv.load(this.msgFile);
        }
        catch (IOException iOException) {
            this.pl.getLogger().severe("Unable to load messages file:");
            iOException.printStackTrace();
            return;
        }
        for (String string : linkedHashMap.keySet()) {
            if (this.msgs.contains(string)) continue;
            this.msgs.set(string, (Object)linkedHashMap.get(string));
        }
        try {
            this.cv.save(this.msgs, this.msgFile);
        }
        catch (IOException iOException) {
            this.pl.getLogger().severe("Unable to save messages file:");
            iOException.printStackTrace();
        }
    }

    @Deprecated
    public String get(String string) {
        String string2 = (String)this.msgs.get(string, (Object)("&cMessage '" + string + "' does not exist!"));
        string2 = this.color(string2);
        return string2;
    }

    public String getString(String string, String ... stringArray) {
        String string2 = (String)this.msgs.get(string, (Object)("&cMessage '" + string + "' does not exist!"));
        string2 = this.color(string2);
        for (String string3 : stringArray) {
            String string4 = string3.split(":")[0];
            String string5 = string3.replaceFirst(Matcher.quoteReplacement(string4 + ":"), "");
            string2 = string2.replaceAll("\\{" + Matcher.quoteReplacement(string4) + "}", string5);
        }
        return string2;
    }

    public BaseComponent[] getBC(String string, String ... stringArray) {
        return this.getBC(this.getComponent(string, stringArray));
    }

    public BaseComponent[] getBC(Component component) {
        return BungeeComponentSerializer.get().serialize(component);
    }

    public Component getComponent(String string, String ... stringArray) {
        String string2 = this.getString(string, stringArray);
        return MiniMessage.miniMessage().deserialize(string2);
    }

    public String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string).replaceAll(Matcher.quoteReplacement("\\n"), "\n");
    }

    public void reload() {
        this.loadMessagesFile(this.defaultValues);
    }
}

