/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import us.ajg0702.queue.libs.utils.common.UtilsLogger;

public class Updater {
    private final ScheduledExecutorService updateExecutor = Executors.newScheduledThreadPool(1);
    private final UtilsLogger logger;
    private final String currentVersion;
    private final String jarName;
    private boolean enabled;
    private final int resrouceId;
    private final File pluginsFolder;
    private final String downloadCommand;
    private String latestVersion;
    boolean updateAvailable = false;
    boolean ready = false;
    boolean alreadyDownloaded = false;

    public Updater(UtilsLogger utilsLogger, String string, String string2, boolean bl, int n, File file, String string3) {
        this.logger = utilsLogger;
        this.jarName = string2;
        this.enabled = bl;
        this.resrouceId = n;
        this.pluginsFolder = file;
        this.downloadCommand = string3;
        this.currentVersion = string.contains("-") ? string.split("-")[0] : string;
        this.updateExecutor.scheduleAtFixedRate(() -> {
            try {
                this.check();
            }
            catch (Exception exception) {
                utilsLogger.info("Unable to check for update: " + exception.getMessage());
            }
        }, 2L, 120L, TimeUnit.SECONDS);
    }

    public void check() {
        if (!this.enabled) {
            return;
        }
        URL uRL = new URL("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=" + this.resrouceId);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.addRequestProperty("User-Agent", this.jarName + "/" + this.currentVersion);
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IllegalStateException("Response code was " + httpURLConnection.getResponseCode());
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        JsonObject jsonObject = new JsonParser().parse((Reader)inputStreamReader).getAsJsonObject();
        this.latestVersion = jsonObject.get("current_version").getAsString();
        if (this.latestVersion.contains("-")) {
            this.latestVersion = this.latestVersion.split("-")[0];
        }
        if (this.latestVersion.isEmpty()) {
            throw new IllegalStateException("Latest version is empty!");
        }
        String[] stringArray = this.latestVersion.split("\\.");
        String[] stringArray2 = this.currentVersion.split("\\.");
        int n = 0;
        for (String string : stringArray) {
            int n2;
            if (n >= stringArray2.length) break;
            int n3 = Integer.parseInt(string);
            if (n3 > (n2 = Integer.parseInt(stringArray2[n]))) {
                if (n != 0) {
                    int n4;
                    int n5 = Integer.parseInt(stringArray[n - 1]);
                    if (n5 >= (n4 = Integer.parseInt(stringArray2[n - 1]))) {
                        this.updateAvailable = true;
                        break;
                    }
                } else {
                    this.updateAvailable = true;
                    break;
                }
            }
            ++n;
        }
        if (this.updateAvailable && !this.ready) {
            this.logger.info("An update is available! (" + this.latestVersion + ") Do /" + this.downloadCommand + " to download it!");
        } else if (!this.ready) {
            this.logger.info("You are up to date! (" + this.latestVersion + ")");
        }
        this.ready = true;
    }

    public boolean isUpdateAvailable() {
        if (!this.enabled) {
            return false;
        }
        return this.updateAvailable;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAlreadyDownloaded() {
        return this.alreadyDownloaded;
    }

    public boolean downloadUpdate() {
        Object object;
        if (!this.isEnabled()) {
            this.logger.warning("Updater is disabled");
            return false;
        }
        if (!this.isUpdateAvailable()) {
            this.logger.warning("No update is available!");
            return false;
        }
        if (this.isAlreadyDownloaded()) {
            this.logger.warning("The update has already been downloaded!");
            return false;
        }
        List<String> list = Arrays.asList(this.jarName + "-" + this.currentVersion, this.jarName.toLowerCase(Locale.ROOT) + "-" + this.currentVersion, this.jarName.toLowerCase(Locale.ROOT), this.jarName, this.jarName + "-" + this.currentVersion + " (1)", this.jarName + "-" + this.currentVersion + " (2)", this.jarName + "-" + this.currentVersion + " (3)");
        File file = null;
        for (String object2 : list) {
            object = new File(this.pluginsFolder, object2 + ".jar");
            if (!((File)object).exists()) continue;
            file = object;
            break;
        }
        if (file == null) {
            this.logger.severe("Could not find the old plugin jar! Make sure it is named like this: " + this.jarName + "-" + this.currentVersion + ".jar");
            return false;
        }
        try {
            URL uRL = new URL("https://ajg0702.us/pl/updater/jars/" + this.jarName + "-" + this.latestVersion + ".jar");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.addRequestProperty("User-Agent", this.jarName + "/" + this.currentVersion);
            httpURLConnection.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IllegalStateException("Response code was " + httpURLConnection.getResponseCode());
            }
            object = Channels.newChannel(httpURLConnection.getInputStream());
            File file2 = new File(this.pluginsFolder, this.jarName + "-" + this.latestVersion + ".jar");
            this.logger.info(file2.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.getChannel().transferFrom((ReadableByteChannel)object, 0L, Long.MAX_VALUE);
            fileOutputStream.close();
            if (!file.delete()) {
                this.logger.warning("Unable to delete the old jar! You should delete it yourself before restarting.");
            }
            this.updateAvailable = false;
            this.alreadyDownloaded = true;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void shutdown() {
        this.updateExecutor.shutdown();
    }
}

