/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.logic.permissions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.premium.PermissionGetter;
import us.ajg0702.queue.api.premium.PermissionHook;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.logic.permissions.hooks.AquaCoreHook;
import us.ajg0702.queue.logic.permissions.hooks.BuiltInHook;
import us.ajg0702.queue.logic.permissions.hooks.LuckPermsHook;
import us.ajg0702.queue.logic.permissions.hooks.UltraPermissionsHook;

public class PermissionGetterImpl
implements PermissionGetter {
    private final List<PermissionHook> hooks;
    private final QueueMain main;
    private PermissionHook selected;

    public PermissionGetterImpl(QueueMain queueMain) {
        this.hooks = Arrays.asList(new BuiltInHook(queueMain), new LuckPermsHook(queueMain), new UltraPermissionsHook(queueMain), new AquaCoreHook(queueMain));
        this.main = queueMain;
    }

    @Override
    public PermissionHook getSelected() {
        if (this.selected != null) {
            return this.selected;
        }
        if (this.hooks == null) {
            throw new IllegalStateException("Hooks are not initialized yet!");
        }
        for (PermissionHook permissionHook : this.hooks) {
            if (!permissionHook.canUse()) continue;
            this.selected = permissionHook;
        }
        if (this.selected == null) {
            throw new IllegalStateException("All hooks are unusable!");
        }
        this.main.getLogger().info("Using " + this.selected.getName() + " for permissions.");
        return this.selected;
    }

    @Override
    public int getMaxOfflineTime(AdaptedPlayer adaptedPlayer) {
        return this.getHighestPermission(adaptedPlayer, "ajqueue.stayqueued.");
    }

    @Override
    public int getPriority(AdaptedPlayer adaptedPlayer) {
        return this.getHighestPermission(adaptedPlayer, "ajqueue.priority.");
    }

    @Override
    public int getServerPriotity(String string, AdaptedPlayer adaptedPlayer) {
        return this.getHighestPermission(adaptedPlayer, "ajqueue.serverpriority." + string + ".");
    }

    @Override
    public boolean hasContextBypass(AdaptedPlayer adaptedPlayer, String string) {
        if (this.getSelected() == null) {
            return false;
        }
        List<String> list = this.getSelected().getPermissions(adaptedPlayer);
        return list.contains("ajqueue.serverbypass." + string);
    }

    @Override
    public boolean hasUniqueFullBypass(AdaptedPlayer adaptedPlayer, String string) {
        if (adaptedPlayer.hasPermission("ajqueue.joinfullandbypassserver." + string)) {
            return true;
        }
        if (this.getSelected() == null) {
            return false;
        }
        List<String> list = this.getSelected().getPermissions(adaptedPlayer);
        list.removeIf(string2 -> !string2.startsWith("ajqueue.joinfullandbypassserver." + string));
        return list.size() > 0;
    }

    private int getHighestPermission(AdaptedPlayer adaptedPlayer, String string) {
        if (this.getSelected() == null) {
            return -1;
        }
        List<String> list = this.getSelected().getPermissions(adaptedPlayer);
        Iterator<String> iterator = list.iterator();
        String string2 = string + "0";
        while (iterator.hasNext()) {
            int n;
            String string3 = iterator.next();
            if (!string3.startsWith(string)) continue;
            if (string2.isEmpty()) {
                string2 = string3;
                continue;
            }
            int n2 = Integer.parseInt(string3.substring(string.length()));
            if (n2 <= (n = Integer.parseInt(string2.substring(string.length())))) continue;
            string2 = string3;
        }
        return Integer.parseInt(string2.substring(string.length()));
    }
}

