/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.logic.permissions.hooks;

import java.util.ArrayList;
import java.util.List;
import me.activated.core.plugin.AquaCoreAPI;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.premium.PermissionHook;
import us.ajg0702.queue.common.QueueMain;

public class AquaCoreHook
implements PermissionHook {
    private final QueueMain main;

    public AquaCoreHook(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "AquaCore";
    }

    @Override
    public boolean canUse() {
        if (!this.main.getPlatformMethods().hasPlugin("AquaProxy")) {
            return false;
        }
        try {
            if (AquaCoreAPI.INSTANCE == null) {
                this.main.getLogger().warn("AquaCore is installed, but its INSTANCE returned null! Unable to hook into it.");
                return false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.main.getLogger().warning("AquaCore seems to be installed, but its api doesnt seem to be!");
            return false;
        }
        return true;
    }

    @Override
    public List<String> getPermissions(AdaptedPlayer adaptedPlayer) {
        AquaCoreAPI aquaCoreAPI = AquaCoreAPI.INSTANCE;
        ArrayList<String> arrayList = new ArrayList<String>();
        aquaCoreAPI.getPlayerData(adaptedPlayer.getUniqueId()).getActiveGrants().forEach(grant -> {
            if (!grant.isActiveSomewhere() || grant.hasExpired()) {
                return;
            }
            arrayList.addAll(grant.getRank().getAvailablePermissions());
        });
        return arrayList;
    }
}

