/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord.players;

import com.viaversion.viaversion.api.Via;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.bungeecord.BungeeQueue;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeePlayer
implements AdaptedPlayer,
Audience {
    final ProxiedPlayer handle;
    private final boolean viaAvailable;

    @Override
    public void sendActionBar(@NotNull ComponentLike componentLike) {
        this.getAudience().sendActionBar(componentLike);
    }

    @Override
    public void showTitle(@NotNull Title title) {
        this.getAudience().showTitle(title);
    }

    @Override
    public void clearTitle() {
        this.getAudience().clearTitle();
    }

    @Override
    public void resetTitle() {
        this.getAudience().resetTitle();
    }

    @Override
    public void showBossBar(@NotNull BossBar bossBar) {
        this.getAudience().showBossBar(bossBar);
    }

    @Override
    public void hideBossBar(@NotNull BossBar bossBar) {
        this.getAudience().hideBossBar(bossBar);
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        this.getAudience().playSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, double d, double d2, double d3) {
        this.getAudience().playSound(sound, d, d2, d3);
    }

    @Override
    public void stopSound(@NotNull Sound sound) {
        this.getAudience().stopSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        this.getAudience().playSound(sound, emitter);
    }

    @Override
    public void stopSound(@NotNull SoundStop soundStop) {
        this.getAudience().stopSound(soundStop);
    }

    public BungeePlayer(ProxiedPlayer proxiedPlayer) {
        this.handle = proxiedPlayer;
        this.viaAvailable = BungeePlayer.isClassAvailable("com.viaversion.viaversion.api.Via");
    }

    @Override
    public boolean isConnected() {
        return this.handle.isConnected();
    }

    @Override
    public void sendMessage(@NotNull Component component) {
        if (PlainTextComponentSerializer.plainText().serialize(component).isEmpty()) {
            return;
        }
        this.getAudience().sendMessage(component);
    }

    @Override
    public void sendActionBar(@NotNull Component component) {
        if (PlainTextComponentSerializer.plainText().serialize(component).isEmpty()) {
            return;
        }
        this.getAudience().sendActionBar(component);
    }

    @Override
    public void sendMessage(String string) {
        if (string.isEmpty()) {
            return;
        }
        this.getAudience().sendMessage(Component.text(string));
    }

    @Override
    public boolean hasPermission(String string) {
        return this.handle.hasPermission(string);
    }

    @Override
    public String getServerName() {
        if (this.handle.getServer() == null) {
            return null;
        }
        return this.handle.getServer().getInfo().getName();
    }

    @Override
    public AdaptedServer getCurrentServer() {
        if (this.handle.getServer() == null) {
            return null;
        }
        return new BungeeServer(this.handle.getServer().getInfo());
    }

    @Override
    public UUID getUniqueId() {
        return this.handle.getUniqueId();
    }

    @Override
    public void connect(AdaptedServer adaptedServer) {
        Debug.info("Attempting to send " + this.getName() + " to " + adaptedServer.getName());
        this.handle.connect(((BungeeServer)adaptedServer).getHandle());
    }

    @Override
    public int getProtocolVersion() {
        if (this.viaAvailable) {
            return Via.getAPI().getPlayerVersion(this.handle.getUniqueId());
        }
        return this.handle.getPendingConnection().getVersion();
    }

    @Override
    public String getName() {
        return this.handle.getName();
    }

    @Override
    public void kick(Component component) {
        this.handle.disconnect(BungeeComponentSerializer.get().serialize(component));
    }

    @Override
    public List<String> getPermissions() {
        return new ArrayList<String>(this.handle.getPermissions());
    }

    public ProxiedPlayer getHandle() {
        return this.handle;
    }

    private Audience getAudience() {
        return BungeeQueue.adventure().player(this.handle);
    }

    private static boolean isClassAvailable(String string) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BungeePlayer bungeePlayer = (BungeePlayer)object;
        return this.handle.equals(bungeePlayer.handle);
    }

    public int hashCode() {
        return Objects.hash(this.handle);
    }
}

