/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import us.ajg0702.queue.api.PlatformMethods;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.commands.commands.PlayerSender;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.velocity.VelocityQueue;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServer;

public class VelocityMethods
implements PlatformMethods {
    final ProxyServer proxyServer;
    final QueueLogger logger;
    final VelocityQueue plugin;
    List<VelocityServer> serverList = new ArrayList<VelocityServer>();

    public VelocityMethods(VelocityQueue velocityQueue, ProxyServer proxyServer, QueueLogger queueLogger) {
        this.proxyServer = proxyServer;
        this.logger = queueLogger;
        this.plugin = velocityQueue;
    }

    @Override
    public void sendPluginMessage(AdaptedPlayer adaptedPlayer, String string, String ... stringArray) {
        if (adaptedPlayer == null) {
            return;
        }
        Player player = ((VelocityPlayer)adaptedPlayer).getHandle();
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        String string2 = adaptedPlayer.getName();
        if (string2 == null) {
            return;
        }
        byteArrayDataOutput.writeUTF(string);
        for (String string3 : stringArray) {
            byteArrayDataOutput.writeUTF(string3);
        }
        Optional optional = player.getCurrentServer();
        if (!optional.isPresent()) {
            this.logger.warn("Unable to send message to " + adaptedPlayer.getName() + ", as they are not connected to any server!");
            return;
        }
        ((ServerConnection)optional.get()).sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)"ajqueue:tospigot"), byteArrayDataOutput.toByteArray());
    }

    @Override
    public AdaptedPlayer senderToPlayer(ICommandSender iCommandSender) {
        if (iCommandSender instanceof PlayerSender) {
            return ((PlayerSender)iCommandSender).getHandle();
        }
        return new VelocityPlayer((Player)iCommandSender.getHandle());
    }

    @Override
    public String getPluginVersion() {
        Optional optional = this.proxyServer.getPluginManager().getPlugin("ajqueue");
        if (!optional.isPresent()) {
            return "?E";
        }
        Optional optional2 = ((PluginContainer)optional.get()).getDescription().getVersion();
        return optional2.orElse("?V");
    }

    @Override
    public List<AdaptedPlayer> getOnlinePlayers() {
        ArrayList<AdaptedPlayer> arrayList = new ArrayList<AdaptedPlayer>();
        for (Player player : this.proxyServer.getAllPlayers()) {
            arrayList.add(new VelocityPlayer(player));
        }
        return arrayList;
    }

    @Override
    public List<String> getPlayerNames(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Player player : this.proxyServer.getAllPlayers()) {
            if (bl) {
                arrayList.add(player.getUsername().toLowerCase(Locale.ROOT));
                continue;
            }
            arrayList.add(player.getUsername());
        }
        return arrayList;
    }

    @Override
    public AdaptedPlayer getPlayer(String string) {
        Optional optional = this.proxyServer.getPlayer(string);
        if (!optional.isPresent()) {
            return null;
        }
        return new VelocityPlayer((Player)optional.get());
    }

    @Override
    public AdaptedPlayer getPlayer(UUID uUID) {
        Optional optional = this.proxyServer.getPlayer(uUID);
        if (!optional.isPresent()) {
            return null;
        }
        return new VelocityPlayer((Player)optional.get());
    }

    @Override
    public List<String> getServerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RegisteredServer registeredServer : this.proxyServer.getAllServers()) {
            arrayList.add(registeredServer.getServerInfo().getName());
        }
        return arrayList;
    }

    @Override
    public String getImplementationName() {
        return "velocity";
    }

    @Override
    public List<IBaseCommand> getCommands() {
        return this.plugin.commands;
    }

    @Override
    public boolean hasPlugin(String string) {
        return this.proxyServer.getPluginManager().getPlugin(string.toLowerCase(Locale.ROOT)).isPresent();
    }

    @Override
    public AdaptedServer getServer(String string) {
        List<? extends AdaptedServer> list = this.getServers();
        for (AdaptedServer adaptedServer : list) {
            if (!adaptedServer.getName().equals(string)) continue;
            return adaptedServer;
        }
        return null;
    }

    @Override
    public List<? extends AdaptedServer> getServers() {
        boolean bl;
        for (RegisteredServer object : this.proxyServer.getAllServers()) {
            bl = false;
            for (VelocityServer velocityServer2 : new ArrayList<VelocityServer>(this.serverList)) {
                if (!velocityServer2.getHandle().equals(object)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Debug.info("Added " + object.getServerInfo().getName());
            this.serverList.add(new VelocityServer(object));
        }
        for (VelocityServer velocityServer : new ArrayList<VelocityServer>(this.serverList)) {
            bl = false;
            for (VelocityServer velocityServer2 : this.proxyServer.getAllServers()) {
                if (!velocityServer.getHandle().equals(velocityServer2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Debug.info("Removed " + velocityServer.getName());
            this.serverList.remove(velocityServer);
        }
        return this.serverList;
    }

    @Override
    public String getProtocolName(int n) {
        String string = ProtocolVersion.getProtocolVersion((int)n).getMostRecentSupportedVersion();
        if (string.equalsIgnoreCase("Unknown")) {
            return n + "";
        }
        return string;
    }
}

