/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.libs.utils.common.ConfigFile;
import us.ajg0702.queue.spigot.Commands;
import us.ajg0702.queue.spigot.QueueScoreboardActivator;
import us.ajg0702.queue.spigot.api.SpigotAPI;
import us.ajg0702.queue.spigot.communication.ResponseManager;
import us.ajg0702.queue.spigot.placeholders.PlaceholderExpansion;

public class SpigotMain
extends JavaPlugin
implements PluginMessageListener,
Listener {
    private boolean papi = false;
    private PlaceholderExpansion placeholders;
    private ResponseManager responseManager = new ResponseManager();
    private ConfigFile config;
    private boolean hasProxy = false;
    final HashMap<Player, String> queuebatch = new HashMap();

    public void onEnable() {
        SpigotMain.loadConfig0();
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "ajqueue:tospigot", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "ajqueue:toproxy");
        AjQueueSpigotAPI.INSTANCE = AjQueueAPI.SPIGOT_INSTANCE = new SpigotAPI(this.responseManager, this);
        this.getCommand("move").setExecutor((CommandExecutor)new Commands(this));
        this.getCommand("leavequeue").setExecutor((CommandExecutor)new Commands(this));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        boolean bl = this.papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (this.papi) {
            this.placeholders = new PlaceholderExpansion(this);
            this.placeholders.register();
            this.getLogger().info("Registered PlaceholderAPI placeholders");
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (Bukkit.getOnlinePlayers().size() <= 0 || this.queuebatch.size() <= 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Player player : this.queuebatch.keySet()) {
                if (player == null || !player.isOnline()) continue;
                stringBuilder.append(player.getName()).append(":").append(this.queuebatch.get(player)).append(",");
            }
            if (stringBuilder.length() > 1) {
                stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            this.queuebatch.clear();
            this.sendMessage("massqueue", stringBuilder.toString());
        }, 40L, 20L);
        File file = new File(this.getDataFolder(), "config.yml");
        if (file.exists()) {
            file.renameTo(new File(this.getDataFolder(), "spigot-config.yml"));
        }
        try {
            this.config = new ConfigFile(this.getDataFolder(), this.getLogger(), "spigot-config.yml");
        }
        catch (Exception exception) {
            this.getLogger().severe("Unable to read config:");
            exception.printStackTrace();
        }
        this.getLogger().info("Spigot side enabled! v" + this.getDescription().getVersion());
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    public void onPluginMessageReceived(@NotNull String string, @NotNull Player player, byte[] byArray) {
        if (!string.equals("ajqueue:tospigot")) {
            return;
        }
        ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])byArray);
        String string2 = byteArrayDataInput.readUTF();
        if (string2.equals("ack")) {
            this.hasProxy = true;
            return;
        }
        if (string2.equals("inqueueevent")) {
            String string3 = byteArrayDataInput.readUTF();
            Player player2 = Bukkit.getPlayer((String)string3);
            if (player2 == null) {
                return;
            }
            QueueScoreboardActivator queueScoreboardActivator = new QueueScoreboardActivator(player2);
            Bukkit.getPluginManager().callEvent((Event)queueScoreboardActivator);
            return;
        }
        try {
            ComResponse comResponse = ComResponse.from(string2, byteArrayDataInput);
            this.responseManager.executeResponse(comResponse);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            this.getLogger().log(Level.SEVERE, "Error while processing proxy response " + string2 + ": ", exception);
        }
    }

    public void sendMessage(Player player, String string, String string2) {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        player.sendPluginMessage((Plugin)this, "ajqueue:toproxy", byteArrayDataOutput.toByteArray());
    }

    public void sendMessage(String string, String string2) {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this, "ajqueue:toproxy", byteArrayDataOutput.toByteArray());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        if (!this.papi) {
            return;
        }
        this.placeholders.cleanCache(playerQuitEvent.getPlayer());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.hasProxy) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.sendMessage(playerJoinEvent.getPlayer(), "ack", ""), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onServerPing(ServerListPingEvent serverListPingEvent) {
        if (this.config == null) {
            this.getLogger().warning("Server ping before plugin load!");
            return;
        }
        if (!this.config.getBoolean("take-over-motd-for-whitelist")) {
            return;
        }
        if (!Bukkit.hasWhitelist()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (OfflinePlayer offlinePlayer : Bukkit.getWhitelistedPlayers()) {
            stringBuilder.append(offlinePlayer.getUniqueId()).append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        serverListPingEvent.setMotd("ajQueue;whitelisted=" + stringBuilder);
    }

    public ConfigFile getAConfig() {
        return this.config;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=79123&nonce=-56483463").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

