/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.api.spigot.MessagedResponse;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;

public class EstimatedTime
extends Placeholder {
    private final Map<UUID, String> cache = new ConcurrentHashMap<UUID, String>();

    public EstimatedTime(SpigotMain spigotMain) {
        super(spigotMain);
    }

    @Override
    public String getRegex() {
        return "estimated_time";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer offlinePlayer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                MessagedResponse<String> messagedResponse = AjQueueSpigotAPI.getInstance().getEstimatedTime(offlinePlayer.getUniqueId()).get(30L, TimeUnit.SECONDS);
                this.cache.put(offlinePlayer.getUniqueId(), messagedResponse.getEither());
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
            catch (TimeoutException timeoutException) {
                this.plugin.getLogger().log(Level.WARNING, "Timed out while trying to get placeholder data from proxy: ", timeoutException);
            }
        });
        return this.cache.getOrDefault(offlinePlayer.getUniqueId(), "...");
    }

    @Override
    public void cleanCache(Player player) {
        this.cache.remove(player.getUniqueId());
    }
}

