/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.bloodmoon;

import java.util.ArrayList;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.statics.FourTuple;
import me.mrgeneralq.bloodmoon.statics.Statics;
import me.mrgeneralq.bloodmoon.statics.Tuple;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class ActionArgumentsFactory {
    private Bloodmoon bloodmoon;
    private EntityDamageByEntityEvent e;
    private Entity entity;

    public ActionArgumentsFactory(Bloodmoon bloodmoon, EntityDamageByEntityEvent entityDamageByEntityEvent, Entity entity) {
        this.bloodmoon = bloodmoon;
        this.e = entityDamageByEntityEvent;
        this.entity = entity;
    }

    public Object getArguments(String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(Statics.LIGHTING_ACTION)) {
            return this.entity;
        }
        if (string.equalsIgnoreCase(Statics.REINFORCEMENTS_ACTION)) {
            if (stringArray.length < 3) {
                return null;
            }
            return new Object[]{this.entity.getLocation(), stringArray[0], stringArray[1], stringArray[2]};
        }
        if (string.equalsIgnoreCase(Statics.TELEPORT_ACTION)) {
            if (stringArray.length < 1) {
                return null;
            }
            return new Object[]{this.entity.getLocation(), this.entity, stringArray[0]};
        }
        if (string.equalsIgnoreCase(Statics.DEATH_ACTION)) {
            return this.entity;
        }
        if (string.equalsIgnoreCase(Statics.HEAL_ACTION)) {
            if (stringArray.length < 1) {
                return null;
            }
            return new Tuple<LivingEntity, Double>((LivingEntity)this.entity, Double.parseDouble(stringArray[0]));
        }
        if (string.equalsIgnoreCase(Statics.STOP_ACTION)) {
            return this.entity.getWorld();
        }
        if (string.equalsIgnoreCase(Statics.DASH_ACTION)) {
            ArrayList<Player> arrayList = new ArrayList<Player>();
            for (Entity entity : this.entity.getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!(entity instanceof Player)) continue;
                arrayList.add((Player)entity);
            }
            return new Tuple(arrayList, (LivingEntity)this.entity);
        }
        if (string.equalsIgnoreCase(Statics.POTION_EFFECT_ACTION)) {
            if (stringArray.length < 3) {
                return null;
            }
            LivingEntity livingEntity = (LivingEntity)this.entity;
            return new FourTuple<LivingEntity, String, String, String>(livingEntity, stringArray[0], stringArray[1], stringArray[2]);
        }
        if (string.equalsIgnoreCase("swap")) {
            return this.entity;
        }
        if (string.equalsIgnoreCase(Statics.SPEAK_ACTION)) {
            LivingEntity livingEntity = (LivingEntity)this.entity;
            String string2 = String.join((CharSequence)" ", stringArray);
            return new Tuple<LivingEntity, String>(livingEntity, string2);
        }
        if (string.equalsIgnoreCase(Statics.SHIELD_ACTION)) {
            if (stringArray.length < 1) {
                return null;
            }
            LivingEntity livingEntity = (LivingEntity)this.entity;
            return new Object[]{livingEntity, this.e, stringArray[0]};
        }
        if (string.equalsIgnoreCase(Statics.RESPAWN_ACTION)) {
            return this.entity;
        }
        if (string.equalsIgnoreCase(Statics.EXPLODE_ACTION)) {
            if (stringArray.length < 1) {
                return null;
            }
            LivingEntity livingEntity = (LivingEntity)this.entity;
            return new Tuple<LivingEntity, String>(livingEntity, stringArray[0]);
        }
        if (string.equalsIgnoreCase(Statics.SOUND_ACTION)) {
            if (stringArray.length < 3) {
                return null;
            }
            return new FourTuple<Entity, String, String, String>(this.entity, stringArray[0], stringArray[1], stringArray[2]);
        }
        if (string.equalsIgnoreCase(Statics.INVISIBLE_ACTION)) {
            if (stringArray.length < 1) {
                return null;
            }
            return new Tuple<Entity, String>(this.entity, stringArray[0]);
        }
        return null;
    }
}

