/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.bloodmoon;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.actions.IBloodmoonAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class MobReinforcementAction
implements IBloodmoonAction {
    private final IBloodmoonService bloodmoonService;
    private final IMobService mobService;
    private String[] args;

    public MobReinforcementAction(IBloodmoonService iBloodmoonService, IMobService iMobService) {
        this.bloodmoonService = iBloodmoonService;
        this.mobService = iMobService;
    }

    @Override
    public void executeAction(Object object) {
        if (!(object instanceof Object[])) {
            return;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length < 4) {
            return;
        }
        try {
            Location location = (Location)objectArray[0];
            String string = String.valueOf(objectArray[1]);
            DefaultMob defaultMob = this.mobService.getMob(string);
            EntityType entityType = null;
            if (defaultMob == null) {
                entityType = Statics.getEntityType(string);
            }
            int n = Integer.parseInt((String)objectArray[2]);
            int n2 = Integer.parseInt((String)objectArray[3]);
            for (int i = 0; i < n2; ++i) {
                Location location2 = Statics.getLocation(location, n);
                LivingEntity livingEntity = null;
                if (defaultMob == null) {
                    livingEntity = this.mobService.spawnMob(location2, entityType);
                } else if (Bukkit.getPluginManager().isPluginEnabled("MythicMobs") && MythicProvider.get().getMobManager().getMobNames().contains(string)) {
                    Optional optional = MythicProvider.get().getMobManager().getMythicMob(string);
                    if (optional.isPresent()) {
                        Position position = Position.of((Location)location);
                        AbstractLocation abstractLocation = new AbstractLocation(position);
                        ActiveMob activeMob = ((MythicMob)optional.get()).spawn(abstractLocation, 0.0);
                        livingEntity = (LivingEntity)activeMob.getEntity().getBukkitEntity();
                    } else {
                        livingEntity = this.mobService.spawnMob(location2, defaultMob);
                    }
                } else {
                    livingEntity = this.mobService.spawnMob(location2, defaultMob);
                }
                this.bloodmoonService.registerMob(livingEntity, livingEntity.getWorld());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setArgs(String[] stringArray) {
        this.args = stringArray;
    }

    @Override
    public String getName() {
        return Statics.REINFORCEMENTS_ACTION;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isValidArgs(String[] stringArray) {
        try {
            DefaultMob defaultMob = this.mobService.getMob(String.valueOf(this.args[0]));
            EntityType entityType = null;
            if (defaultMob == null) {
                entityType = Statics.getEntityType(String.valueOf(this.args[0]));
            }
            Integer.parseInt(stringArray[1]);
            Integer.parseInt(stringArray[2]);
            return defaultMob != null || entityType != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getArgsUsage() {
        return String.format("%s <custom mob/entity type> <radius> <amount>", Statics.REINFORCEMENTS_ACTION);
    }
}

