/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands;

import io.lumine.mythic.api.MythicProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.ITabCompleteParent;
import me.mrgeneralq.bloodmoon.interfaces.services.IActionService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.generator.WorldInfo;

public class OnTabComplete
implements TabCompleter {
    private final IBloodmoonService bloodmoonService;
    private HashMap<String, Set<String>> secondOrder = new HashMap();
    private HashMap<String, ITabCompleteParent> items = new HashMap();
    private HashMap<String, ITabCompleteParent> itemsFifth = new HashMap();
    private HashMap<String, ITabCompleteParent> thirdMobs = new HashMap();
    private HashMap<String, ITabCompleteParent> fourthMobs = new HashMap();
    private HashMap<String, ITabCompleteParent> mobsSet = new HashMap();
    private HashMap<String, ITabCompleteParent> lifecycles = new HashMap();
    private HashMap<String, ITabCompleteParent> thirdlifecycles = new HashMap();
    private HashMap<String, ITabCompleteParent> actions = new HashMap();
    private HashMap<String, ITabCompleteParent> fourthActions = new HashMap();
    private HashMap<String, ITabCompleteParent> schedules = new HashMap();
    private HashMap<String, ITabCompleteParent> thirdSchedules = new HashMap();
    private HashMap<String, ITabCompleteParent> schedulesSet = new HashMap();

    public OnTabComplete(IBloodmoonService iBloodmoonService, IMobService iMobService, IItemService iItemService, ILifeCycleService iLifeCycleService, IActionService iActionService, IConfigService iConfigService, IBloodmoonScheduleService iBloodmoonScheduleService) {
        this.bloodmoonService = iBloodmoonService;
        this.secondOrder.put("item", this.bloodmoonService.getItemSubCommands().keySet());
        this.secondOrder.put("mob", this.bloodmoonService.getMobSubCommands().keySet());
        this.secondOrder.put("lifecycle", this.bloodmoonService.getLifeCycleSubCommands().keySet());
        this.secondOrder.put("action", this.bloodmoonService.getActionSubCommands().keySet());
        this.secondOrder.put("schedule", this.bloodmoonService.getScheduleSubCommands().keySet());
        this.items.put("get", new ModifiedItems((ITabCompleteParent)((Object)iItemService)));
        this.items.put("remove", (ITabCompleteParent)((Object)iItemService));
        this.items.put("give", new ModifiedItems((ITabCompleteParent)((Object)iItemService)));
        this.itemsFifth.put("give", new PlayerList());
        this.thirdMobs.put("spawn", (ITabCompleteParent)((Object)iMobService));
        this.thirdMobs.put("spawn-boss", new BossMobs(iMobService));
        this.thirdMobs.put("remove", (ITabCompleteParent)((Object)iMobService));
        this.thirdMobs.put("set", (ITabCompleteParent)((Object)this.bloodmoonService));
        this.thirdMobs.put("add-drop", (ITabCompleteParent)((Object)iMobService));
        this.fourthMobs.put("create", new EntitiesList(iMobService));
        this.fourthMobs.put("set", (ITabCompleteParent)((Object)iMobService));
        this.fourthMobs.put("add-drop", new ModifiedItems((ITabCompleteParent)((Object)iItemService)));
        this.mobsSet.put("lifecycle", (ITabCompleteParent)((Object)iLifeCycleService));
        this.mobsSet.put("boss", new BooleanList());
        this.mobsSet.put("angry", new BooleanList());
        this.mobsSet.put("baby", new BooleanList());
        this.mobsSet.put("glowing", new BooleanList());
        this.mobsSet.put("powered", new BooleanList());
        this.mobsSet.put("helmet", (ITabCompleteParent)((Object)iItemService));
        this.mobsSet.put("chestplate", (ITabCompleteParent)((Object)iItemService));
        this.mobsSet.put("leggings", (ITabCompleteParent)((Object)iItemService));
        this.mobsSet.put("boots", (ITabCompleteParent)((Object)iItemService));
        this.mobsSet.put("hand", (ITabCompleteParent)((Object)iItemService));
        this.mobsSet.put("mythicmob", new MythicList());
        this.mobsSet.put("surface-spawn", new BooleanList());
        this.lifecycles.put("remove", (ITabCompleteParent)((Object)iLifeCycleService));
        this.lifecycles.put("remove-action", (ITabCompleteParent)((Object)iLifeCycleService));
        this.lifecycles.put("add-action", (ITabCompleteParent)((Object)iLifeCycleService));
        this.lifecycles.put("actions", (ITabCompleteParent)((Object)iLifeCycleService));
        this.thirdlifecycles.put("add-action", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("remove", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("add-event", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("add-command", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("events", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("remove-event", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("remove-command", (ITabCompleteParent)((Object)iActionService));
        this.actions.put("commands", (ITabCompleteParent)((Object)iActionService));
        this.fourthActions.put("add-event", new Statics.ActionList());
        this.schedules.put("create", new EnabledWorlds(iConfigService));
        this.schedules.put("remove", new SavedWorlds(iBloodmoonScheduleService));
        this.schedules.put("info", new SavedWorlds(iBloodmoonScheduleService));
        this.schedules.put("set", new ScheduleProperties(iBloodmoonService));
        this.thirdSchedules.put("set", new SavedWorlds(iBloodmoonScheduleService));
        this.schedulesSet.put("broadcast", new BooleanList());
        this.schedulesSet.put("random", new BooleanList());
        this.schedulesSet.put("repeating", new BooleanList());
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string2, String[] stringArray) {
        if (stringArray.length == 0) {
            return this.bloodmoonService.getSubCommands().keySet().stream().filter(string -> commandSender.hasPermission("bloodmoon." + string)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 1) {
            return this.processArgs1(commandSender, stringArray);
        }
        if (stringArray.length == 2) {
            return this.processArgs2(commandSender, stringArray);
        }
        if (stringArray[0].equalsIgnoreCase("item")) {
            return this.processArgsItem(commandSender, stringArray);
        }
        if (stringArray[0].equalsIgnoreCase("mob")) {
            return this.processArgsMob(commandSender, stringArray);
        }
        if (stringArray[0].equalsIgnoreCase("lifecycle")) {
            return this.processArgsLifeCycle(commandSender, stringArray);
        }
        if (stringArray[0].equalsIgnoreCase("action")) {
            return this.processArgsActions(commandSender, stringArray);
        }
        if (stringArray[0].equalsIgnoreCase("schedule")) {
            return this.processArgsSchedules(commandSender, stringArray);
        }
        return new ArrayList<String>();
    }

    private List<String> processArgs1(CommandSender commandSender, String[] stringArray) {
        String string3 = stringArray[0].toLowerCase();
        return this.bloodmoonService.getSubCommands().keySet().stream().filter(string -> commandSender.hasPermission("bloodmoon." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
    }

    private List<String> processArgs2(CommandSender commandSender, String[] stringArray) {
        String string3 = stringArray[1].toLowerCase();
        return ((Set)this.secondOrder.getOrDefault(stringArray[0], new HashSet())).stream().filter(string -> commandSender.hasPermission("bloodmoon." + stringArray[0].toLowerCase() + "." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
    }

    private List<String> processArgsItem(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 3) {
            String string3 = stringArray[2].toLowerCase();
            return this.items.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.item." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 5) {
            String string4 = stringArray[4].toLowerCase();
            return this.itemsFifth.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.item." + string)).filter(string2 -> string2.toLowerCase().startsWith(string4)).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> processArgsMob(CommandSender commandSender, String[] stringArray) {
        String string3 = stringArray[2].toLowerCase();
        if (stringArray.length == 3) {
            return this.thirdMobs.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.mob." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 4) {
            String string4 = stringArray[3].toLowerCase();
            return this.fourthMobs.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.mob." + string)).filter(string2 -> string2.toLowerCase().startsWith(string4)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 5) {
            String string5 = stringArray[4].toLowerCase();
            return this.mobsSet.getOrDefault(stringArray[2], new EmptyList()).get().stream().filter(string2 -> string2.toLowerCase().startsWith(string5)).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> processArgsLifeCycle(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 3) {
            String string3 = stringArray[2];
            return this.lifecycles.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.lifecycle." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 4) {
            String string4 = stringArray[3];
            return this.thirdlifecycles.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.lifecycle." + string)).filter(string2 -> string2.toLowerCase().startsWith(string4)).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> processArgsActions(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 3) {
            String string3 = stringArray[2];
            return this.actions.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.action." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 5) {
            String string4 = stringArray[4];
            return this.fourthActions.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.action." + string)).filter(string2 -> string2.toLowerCase().startsWith(string4)).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> processArgsSchedules(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 3) {
            String string3 = stringArray[2];
            return this.schedules.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.schedule." + string)).filter(string2 -> string2.toLowerCase().startsWith(string3)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 4) {
            String string4 = stringArray[3].toLowerCase();
            return this.thirdSchedules.getOrDefault(stringArray[1], new EmptyList()).get().stream().filter(string -> commandSender.hasPermission("bloodmoon.schedule." + string)).filter(string2 -> string2.toLowerCase().startsWith(string4)).sorted().collect(Collectors.toList());
        }
        if (stringArray.length == 5) {
            String string5 = stringArray[4].toLowerCase();
            return this.schedulesSet.getOrDefault(stringArray[2], new EmptyList()).get().stream().filter(string2 -> string2.toLowerCase().startsWith(string5)).sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    static class ModifiedItems
    implements ITabCompleteParent {
        private final ITabCompleteParent items;

        ModifiedItems(ITabCompleteParent iTabCompleteParent) {
            this.items = iTabCompleteParent;
        }

        @Override
        public Set<String> get() {
            Set<String> set = this.items.get();
            set.add(Statics.PATH_FINDER_NAME);
            return set;
        }
    }

    static class PlayerList
    implements ITabCompleteParent {
        PlayerList() {
        }

        @Override
        public Set<String> get() {
            return Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toSet());
        }
    }

    static class BossMobs
    implements ITabCompleteParent {
        private final IMobService mobService;

        BossMobs(IMobService iMobService) {
            this.mobService = iMobService;
        }

        @Override
        public Set<String> get() {
            return this.mobService.getAllMobs().stream().filter(DefaultMob::isBoss).map(DefaultMob::getMobID).collect(Collectors.toSet());
        }
    }

    static class EntitiesList
    implements ITabCompleteParent {
        private final IMobService mobService;

        EntitiesList(IMobService iMobService) {
            this.mobService = iMobService;
        }

        @Override
        public Set<String> get() {
            return Arrays.stream(EntityType.values()).map(Enum::toString).filter(this.mobService::isValidEntityType).collect(Collectors.toSet());
        }
    }

    static class BooleanList
    implements ITabCompleteParent {
        BooleanList() {
        }

        @Override
        public Set<String> get() {
            return Stream.of(true, false).map(Object::toString).collect(Collectors.toSet());
        }
    }

    static class MythicList
    implements ITabCompleteParent {
        MythicList() {
        }

        @Override
        public Set<String> get() {
            if (Bukkit.getPluginManager().isPluginEnabled("MythicMobs")) {
                return new HashSet<String>(MythicProvider.get().getMobManager().getMobNames());
            }
            return new HashSet<String>();
        }
    }

    static class EnabledWorlds
    implements ITabCompleteParent {
        private final IConfigService configService;

        EnabledWorlds(IConfigService iConfigService) {
            this.configService = iConfigService;
        }

        @Override
        public Set<String> get() {
            return Bukkit.getWorlds().stream().filter(this.configService::worldIsEnabled).map(WorldInfo::getName).collect(Collectors.toSet());
        }
    }

    static class SavedWorlds
    implements ITabCompleteParent {
        private final IBloodmoonScheduleService scheduleService;

        SavedWorlds(IBloodmoonScheduleService iBloodmoonScheduleService) {
            this.scheduleService = iBloodmoonScheduleService;
        }

        @Override
        public Set<String> get() {
            return this.scheduleService.getAllScheduleIds();
        }
    }

    static class ScheduleProperties
    implements ITabCompleteParent {
        private final IBloodmoonService bloodmoonService;

        ScheduleProperties(IBloodmoonService iBloodmoonService) {
            this.bloodmoonService = iBloodmoonService;
        }

        @Override
        public Set<String> get() {
            return this.bloodmoonService.getScheduleCommandProperties().keySet();
        }
    }

    static class EmptyList
    implements ITabCompleteParent {
        EmptyList() {
        }

        @Override
        public Set<String> get() {
            return new HashSet<String>();
        }
    }
}

