/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.mrgeneralq.bloodmoon.commands.subcommands.ErrorCommand;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScheduleSubCommand
implements ISubCommand {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final IBloodmoonScheduleService bloodmoonScheduleService;
    private final IConfigService configService;
    private final HashMap<String, ISubCommand> subCommands;

    public ScheduleSubCommand(IBloodmoonService iBloodmoonService, IMessageService iMessageService, IBloodmoonScheduleService iBloodmoonScheduleService, IConfigService iConfigService) {
        this.subCommands = iBloodmoonService.getScheduleSubCommands();
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.bloodmoonScheduleService = iBloodmoonScheduleService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        if (stringArray.length == 0) {
            if (!commandSender.hasPermission("bloodmoon.schedule.help")) {
                commandSender.sendMessage(this.messageService.getMessage(Message.noPermission, true));
                return true;
            }
            List<String> list = this.bloodmoonService.getScheduleCommands();
            Message.showHelpMenu(list, commandSender);
            return true;
        }
        String string2 = stringArray[0];
        if (!commandSender.hasPermission(String.format("bloodmoon.schedule.%s", string2))) {
            commandSender.sendMessage(this.messageService.getMessage(Message.noPermission, true));
            return true;
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
        this.bloodmoonService.getScheduleSubCommands().getOrDefault(string2, new ErrorCommand(this.messageService)).executeCommand(commandSender, command, string, stringArray2);
        return true;
    }
}

