/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.item;

import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveItem
implements ISubCommand {
    private final IItemService itemService;
    private final IMessageService messageService;
    private final IConfigService configService;

    public GiveItem(IItemService iItemService, IMessageService iMessageService, IConfigService iConfigService) {
        this.itemService = iItemService;
        this.messageService = iMessageService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        int n;
        ItemStack itemStack;
        if (stringArray.length < 1) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        DefaultItem defaultItem = this.itemService.getItem(stringArray[0]);
        if (defaultItem == null && !stringArray[0].equalsIgnoreCase(Statics.PATH_FINDER_NAME)) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        Material material = Material.matchMaterial((String)this.configService.getPathMaterial());
        if (defaultItem == null && material == null) {
            return true;
        }
        ItemStack itemStack2 = itemStack = defaultItem != null ? defaultItem.getItem() : new ItemStack(material);
        if (defaultItem == null) {
            Statics.setPathFinderMeta(itemStack);
        }
        if (stringArray.length < 2) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("count").getMessage());
            return true;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("count").getMessage());
            return true;
        }
        itemStack.setAmount(n);
        if (stringArray.length < 3) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("player").getMessage());
            return true;
        }
        Player player = Bukkit.getPlayer((String)stringArray[2]);
        if (player == null) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("player").getMessage());
            return true;
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
        commandSender.sendMessage(this.messageService.getMessageHelper(Message.itemReceived).useConfigMessage().usePrefix().setPlayer(player.getDisplayName()).setAmount(String.valueOf(itemStack.getAmount())).setType(defaultItem != null ? defaultItem.getItemId() : "Pathfinder").getMessage());
        return true;
    }
}

