/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Random;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.models.MobBlock;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class OnBlockBreak
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;

    public OnBlockBreak(IBloodmoonService iBloodmoonService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        World world = blockBreakEvent.getPlayer().getWorld();
        Block block = blockBreakEvent.getBlock();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (!this.configService.isMobBlockEnabled() || !this.configService.mobBlockExists(block.getType())) {
            return;
        }
        if (blockBreakEvent.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        MobBlock mobBlock = this.configService.getMobBlock(block.getType());
        double d = mobBlock.getPercentage();
        Random random = new Random();
        double d2 = random.nextDouble() * 100.0;
        if (d2 < d) {
            LivingEntity livingEntity = (LivingEntity)world.spawnEntity(block.getLocation(), mobBlock.getEntityType());
            this.bloodmoonService.registerMob(livingEntity, world);
        }
    }
}

