/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.ActionArgumentsFactory;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.LifeCycle;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class OnEntityDamage
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMobService mobService;
    private final IConfigService configService;

    public OnEntityDamage(IBloodmoonService iBloodmoonService, IMobService iMobService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.mobService = iMobService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Projectile projectile;
        World world = entityDamageByEntityEvent.getDamager().getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        LivingEntity livingEntity = null;
        LivingEntity livingEntity2 = null;
        if (entityDamageByEntityEvent.getDamager() instanceof Projectile && (projectile = (Projectile)entityDamageByEntityEvent.getDamager()).getShooter() instanceof LivingEntity) {
            livingEntity = (LivingEntity)projectile.getShooter();
        }
        if (entityDamageByEntityEvent.getDamager() instanceof LivingEntity) {
            livingEntity = (LivingEntity)entityDamageByEntityEvent.getDamager();
        }
        if (entityDamageByEntityEvent.getEntity() instanceof LivingEntity) {
            livingEntity2 = (LivingEntity)entityDamageByEntityEvent.getEntity();
        }
        if (livingEntity2 == null || livingEntity == null) {
            return;
        }
        if (livingEntity instanceof Player) {
            this.executeLifeCycle(livingEntity, livingEntity2, entityDamageByEntityEvent);
        } else if (this.configService.isLifeCycleMobProgressEnabled()) {
            this.executeLifeCycle(livingEntity2, livingEntity, entityDamageByEntityEvent);
        }
    }

    private boolean checkShieldStatus(LivingEntity livingEntity, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        List list = livingEntity.getMetadata("shieldDuration");
        if (list.size() == 0) {
            return false;
        }
        MetadataValue metadataValue = (MetadataValue)list.get(0);
        if (!(metadataValue instanceof FixedMetadataValue)) {
            return false;
        }
        FixedMetadataValue fixedMetadataValue = (FixedMetadataValue)metadataValue;
        int n = (Integer)fixedMetadataValue.value();
        this.bloodmoonService.checkActiveShield(livingEntity.getUniqueId(), n);
        if (this.bloodmoonService.getActiveShields().containsKey(livingEntity.getUniqueId())) {
            Statics.createShieldEffect(livingEntity.getLocation());
            entityDamageByEntityEvent.setCancelled(true);
            return true;
        }
        return false;
    }

    private void executeLifeCycle(LivingEntity livingEntity, LivingEntity livingEntity2, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        World world = livingEntity2.getWorld();
        DefaultMob defaultMob = this.mobService.getMob(livingEntity2);
        if (defaultMob == null) {
            return;
        }
        if (this.checkShieldStatus(livingEntity2, entityDamageByEntityEvent)) {
            return;
        }
        LifeCycle lifeCycle = this.mobService.getLifeCycle(livingEntity2.getUniqueId());
        if (lifeCycle == null) {
            return;
        }
        ActionArgumentsFactory actionArgumentsFactory = new ActionArgumentsFactory((Bloodmoon)this.bloodmoonService.getAllBloodmoons().stream().filter(bloodmoon -> bloodmoon.getWorld() == livingEntity2.getWorld()).collect(Collectors.toList()).get(0), entityDamageByEntityEvent, (Entity)livingEntity2);
        lifeCycle.update(actionArgumentsFactory, livingEntity2.getHealth(), livingEntity2.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), (Entity)livingEntity, world);
    }
}

